/*
 * @ (#) CmppTerminatePacket.java Jun 8, 2008
 *
 * 
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import java.nio.ByteBuffer;




/**
 * CMPP_TERMINATE
 * 
 * <p>
 * 参照：中国移动通信互联网短信网关接口协议CMPP3.0, 中国移动通信互联网短信网关接口协议CMPP2.0
 * </p>
 *
 * @author	Wang Shenggong
 * @version 1.0.0
 * @since 1.0.0
 *
 */
public class CmppTerminatePacket extends CmppPacket {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public CmppTerminatePacket(){
		totalLength = CmppPacket.CMPP_TERMINATE_LENGTH;
		commandId = CmppPacket.CMPP_TERMINATE;
	}
	public byte[] pack() throws PacketException{
		super.pack();
		
		return getBytes();
	}

	public CmppPacket unpack(ByteBuffer buffer) throws PacketException{
		super.unpack(buffer);
		
		return this;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		
		sb.append("CMPP_TERMINATE:");
		sb.append("Sequence_Id=").append(sequenceId);
		
		return sb.toString();
	}
}
