/*
 * @ (#) CmppSubmitRespPacket.java Jun 8, 2008
 *
 * 
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Map;






/**
 * CMPP_SUBMIT_RESP
 * 
 * <p>
 * 参照：中国移动通信互联网短信网关接口协议CMPP3.0, 中国移动通信互联网短信网关接口协议CMPP2.0
 * </p>
 *
 * @author	Wang Shenggong
 * @version 1.0.0
 * @since 1.0.0
 *
 */
public class CmppSubmitRespPacket extends CmppPacket {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
//	public static int RESULT_COMMAND_ID_ERR = 2;
//	public static int RESULT_SEQ_ID_REPEAT = 3;
//	public static int RESULT_WRONG_GATEWAY_ERR = 9;
//	public static int RESULT_MSG_SRC_ERR = 11;
//	public static int RESULT_FEE_TERMINAL_ID_ERR = 12;
//	public static int RESULT_DEST_TERMINAL_ID_ERR = 13;
//	public static int BATCH_PERMIT_DISABLE = 15;
//	public static int RESULT_AMQ_ERR = 16;
	
	
	
	
	
	public static Map<Integer,String> FailDetailMap= new Hashtable<Integer,String>();
	
	public static int RESULT_OK = 0;
	public static int RESULT_FEETYPE_ERR = 1;
	public static int RESULT_MSG_LENGTH_ERR = 4;
	public static int RESULT_FEE_CODE_ERR = 5;
	public static int RESULT_MSG_TOO_LONG = 6;
	public static int RESULT_SERVICE_ID_ERR = 7;
	public static int RESULT_SECONDLIMIT_ERR = 8;
	public static int RESULT_MINLIMIT_ERR = 18;
	public static int RESULT_HOURLIMIT_ERR = 28;
	public static int RESULT_DAYLIMIT_ERR = 38;
	public static int RESULT_SRC_ID_ERR = 10;
	public static int RESULT_DEST_TERMINAL_ID_ERR = 13;
	public static int RESULT_REJECT = 14;
	public static int RESULT_FILTER_KEYWORD = 15;
	public static int RESULT_DEST_TERMINAL_ID_WHILE_ERR = 17;
	public static int RESULT_DEST_TERMINAL_ID_BLACK_ERR = 18;
	
	static{
		FailDetailMap.put(RESULT_FEETYPE_ERR, "feeType错误");
		FailDetailMap.put(RESULT_MSG_LENGTH_ERR, "消息长度错误");
		FailDetailMap.put(RESULT_FEE_CODE_ERR, "feeCode错误");
		FailDetailMap.put(RESULT_MSG_TOO_LONG, "消息过长");
		FailDetailMap.put(RESULT_SERVICE_ID_ERR, "serviceId错误");
		FailDetailMap.put(RESULT_SECONDLIMIT_ERR, "每秒发送超过阀值错误");
		FailDetailMap.put(RESULT_DAYLIMIT_ERR, "当日发送超过阀值错误");
		FailDetailMap.put(RESULT_SRC_ID_ERR, "srcid错误");
		FailDetailMap.put(RESULT_DEST_TERMINAL_ID_ERR, "destTerminalId错误");
		FailDetailMap.put(RESULT_REJECT, "使用上行连接发送下行错误");
		FailDetailMap.put(RESULT_FILTER_KEYWORD, "含有关键字被过滤");
//		FailDetailMap.put(RESULT_KEYWORD_CACHE, "长短信缓存内容(拼接完成后验证关键字)");
		FailDetailMap.put(RESULT_DEST_TERMINAL_ID_WHILE_ERR, "非白名单错误");
		FailDetailMap.put(RESULT_DEST_TERMINAL_ID_BLACK_ERR, "黑名单错误");
	}
	
	
	
	private long msgId;
	
	private int result;
	
	public CmppSubmitRespPacket(Version version){
		super(version);
		commandId = CmppPacket.CMPP_SUBMIT_RESP;
		totalLength = version.isVersion3() ? CmppPacket.CMPP_SUBMIT_RESP_LENGTH_V30 : CmppPacket.CMPP_SUBMIT_RESP_LENGTH_V20;
	}
	
	
	public byte[] pack() throws PacketException{
		super.pack();
		
		try {
			putLong(msgId);
			
			if(version.isVersion3())
				putInt(result);
			else if(version.isVersion2())
				put((byte)result);
			
		} catch (Exception e) {
			throw new PacketException("Unexpected Exception on packing CmppSubmitRespPacket: TotalLength=" + totalLength + ", CommandId=" + Integer.toHexString(commandId) + ", SequenceId=" + sequenceId, e);
		}
		
		return getBytes();
	}

	/* (non-Javadoc)
	 * @see icf.socket.codec.cmpp.packet.CmppPacket#unpack()
	 */
	
	public CmppPacket unpack(ByteBuffer buffer) throws PacketException{
		super.unpack(buffer);
		
		try {
			msgId = getLong();
			result = getInt();
			
		} catch (Exception e) {
			throw new PacketException("Unexpected Exception on unpacking CmppSubmitRespPacket: TotalLength=" + totalLength + ", CommandId=" + Integer.toHexString(commandId) + ", SequenceId=" + sequenceId, e);
		}
		
		return this;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		
		sb.append("CMPP_SUBMIT_RESP:");
		sb.append("Sequence_Id=").append(sequenceId);
		sb.append(", Msg_Id=").append(msgId);
		sb.append(", Result=").append(result);
		
		return sb.toString();
	}


	/**
	 * @return the msgId
	 */
	public long getMsgId() {
		return msgId;
	}


	/**
	 * @param msgId the msgId to set
	 */
	public void setMsgId(long msgId) {
		this.msgId = msgId;
	}


	/**
	 * @return the result
	 */
	public int getResult() {
		return result;
	}


	/**
	 * @param result the result to set
	 */
	public void setResult(int result) {
		this.result = result;
	}
	
	
	
}
