
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import java.nio.ByteBuffer;



/**
 * CMPP_DELIVER_RESP
 * 
 * <p>
 * 参照：中国移动通信互联网短信网关接口协议CMPP3.0, 中国移动通信互联网短信网关接口协议CMPP2.0
 * </p>
 *
 * @author	Wang Shenggong
 * @version 1.0.0
 * @since 1.0.0
 *
 */
public class CmppDeliverRespPacket extends CmppPacket {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public static int RESULT_OK = 0;
	public static int RESULT_STRUCTURE_ERR = 1;
	public static int RESULT_COMMAND_ID_ERR = 2;
	public static int RESULT_SEQ_ID_REPEAT = 3;
	public static int RESULT_LENGTH_ERR = 4;
	public static int RESULT_FEE_CODE_ERR = 5;
	public static int RESULT_TOO_LONG = 6;
	public static int RESULT_SERVICE_ID_ERR = 7;
	public static int RESULT_TRAFFIC_ERR = 8;
	public static int RESULT_OTHER_ERR = 9;
	
	// Msg_Id
	private long msgId;
	
	// Result
	private int result;
	
	public CmppDeliverRespPacket(){
		totalLength = version.isVersion3() ? CmppPacket.CMPP_DELIVER_RESP_LENGTH_V30 : CmppPacket.CMPP_DELIVER_RESP_LENGTH_V20;
		commandId = CmppPacket.CMPP_DELIVER_RESP;
	}
	
	public CmppDeliverRespPacket(Version version){
		super(version);
		totalLength = version.isVersion3() ? CmppPacket.CMPP_DELIVER_RESP_LENGTH_V30 : CmppPacket.CMPP_DELIVER_RESP_LENGTH_V20;
		commandId = CmppPacket.CMPP_DELIVER_RESP;
	}
	
	public byte[] pack() throws PacketException{
		super.pack();
		try {
			putLong(msgId);
			if(version.isVersion3())
				putInt(result);
			else if(version.isVersion2())
				put((byte)result);
		} catch (Exception e) {
			throw new PacketException("Unexpected Exception on packing CmppDeliverRespPacket: TotalLength=" + totalLength + ", CommandId=" + Integer.toHexString(commandId) + ", SequenceId=" + sequenceId, e);
		}
		return getBytes();
	}

	
	public CmppPacket unpack(ByteBuffer buffer) throws PacketException{
		super.unpack(buffer);
		try {
			msgId = getLong();
			result = version.isVersion3() ? getInt() : get();
		} catch (Exception e) {
			throw new PacketException("Unexpected Exception on unpacking CmppDeliverRespPacket: TotalLength=" + totalLength + ", CommandId=" + Integer.toHexString(commandId) + ", SequenceId=" + sequenceId, e);
		}
		
		return this;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		
		sb.append("CMPP_DELIVER_RESP:");
		sb.append("Sequence_Id=").append(sequenceId);
		sb.append(", Msg_Id=").append(msgId);
		sb.append(", Result=").append(result);
		
		return sb.toString();
	}

	/**
	 * @return the msgId
	 */
	public long getMsgId() {
		return msgId;
	}

	/**
	 * @param msgId the msgId to set
	 */
	public void setMsgId(long msgId) {
		this.msgId = msgId;
	}

	/**
	 * @return the result
	 */
	public int getResult() {
		return result;
	}

	/**
	 * @param result the result to set
	 */
	public void setResult(int result) {
		this.result = result;
	}
	
	
	
}
