/*
 * @ (#) CmppConnectRespPacket.java Jun 8, 2008
 *
 * 
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import java.nio.ByteBuffer;

import com.aspire.nm.component.commonUtil.bytes.BytesUtil;




/**
 * CMPP_CONNECT_RESP
 * 
 * <p>
 * 参照：中国移动通信互联网短信网关接口协议CMPP3.0, 中国移动通信互联网短信网关接口协议CMPP2.0
 * </p>
 *
 * @author	Wang Shenggong
 * @version 1.0.0
 * @since 1.0.0
 *
 */
public class CmppConnectRespPacket extends CmppPacket {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 登陆成功
	 */
	public static final int STATUS_SUCCESS = 0;
	
	/**
	 * 消息结构错误
	 */
//	public static final int STATUS_MESSAGE_STRUCTURE_ERR = 1;
	
	/**
	 * 非法源地址
	 */
	public static final int STATUS_SRC_ADDRESS_ERR = 2;
	
	/**
	 * 认证错误
	 */
	public static final int STATUS_AUTH_ERR = 3;
	
	/**
	 * 协议版本不支持
	 */
//	public static final int STATUS_VERSION_ERR = 4;
	
	/**
	 * 连接数限制
	 */
	public static final int STATUS_CONNECTIONS_LIMIT = 1001;
	
	/**
	 * IP地址受限制
	 */
	public static final int STATUS_IP_LIMIT = 1002;
	
	/**
	 * 其他原因
	 */
//	public static final int STATUS_OTHER_ERR = 2000;
	
	/* 状态*/
	private int status;
	
	/* ISMG认证码 */
	private byte[] authenticatorISMG;
	
	
	
	public CmppConnectRespPacket(Version version){
		super(version);
		commandId = CmppPacket.CMPP_CONNECT_RESP;
		
		if(version.isVersion3())
			totalLength = CmppPacket.CMPP_CONNECT_RESP_LENGTH_V30;
		else if(version.isVersion2())
			totalLength = CmppPacket.CMPP_CONNECT_RESP_LENGTH_V20;
	}

	
	public byte[] pack() throws PacketException{
		super.pack();
		
		try {
			if(version.isVersion3())
				putInt(status);
			else if(version.isVersion2())
				put((byte)status);
			
			put(authenticatorISMG, 0, 16);
			put(version.getVersion());
		} catch (Exception e) {
			throw new PacketException("Unexpected Exception on packing CmppConnectRespPacket: TotalLength=" + totalLength + ", CommandId=" + Integer.toHexString(commandId) + ", SequenceId=" + sequenceId, e);
		}
		return getBytes();
	}

	public CmppPacket unpack(ByteBuffer buffer) throws PacketException{
		super.unpack(buffer);
		
		try {
			status = getInt();
			authenticatorISMG = new byte[16];
			get(authenticatorISMG);
			
			int ver = get();
			version = Version.toVersion(ver);		
		} catch (Exception e) {
			throw new PacketException("Unexpected Exception on unpacking CmppConnectRespPacket: TotalLength=" + totalLength + ", CommandId=" + Integer.toHexString(commandId) + ", SequenceId=" + sequenceId, e);
		}
		return this;
	}

	/**
	 * @return the status
	 */
	public int getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(int status) {
		this.status = status;
	}

	/**
	 * @return the authenticatorISMG
	 */
	public byte[] getAuthenticatorISMG() {
		return authenticatorISMG;
	}

	/**
	 * @param authenticatorISMG the authenticatorISMG to set
	 */
	public void setAuthenticatorISMG(byte[] authenticatorISMG) {
		this.authenticatorISMG = authenticatorISMG;
	}

	/**
	 * @return the version
	 */
	public Version getVersion() {
		return version;
	}

	/**
	 * @param version the version to set
	 */
	public void setVersion(Version version) {
		this.version = version;
	}
	
	/**
	 * 取得authenticatorSource的十六进制字符串
	 * @return authenticatorSource的十六进制字符串
	 */
	public String getAuthenticatorISMGHexString(){
		return BytesUtil.bytes2hex(authenticatorISMG);
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		
		sb.append("CMPP_CONNECT_RESP:");
		sb.append("Sequence_Id=").append(sequenceId);
		
		sb.append(",Status=").append(status);
		sb.append(",AuthenticatorISMG=").append(getAuthenticatorISMGHexString());
		sb.append(",Version=").append(version.getDescription());
		
		return sb.toString();
	}
}
