/*
 * @ (#) CmppConnectPacket.java Jun 8, 2008
 *
 * 
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;



import java.nio.ByteBuffer;

import com.aspire.nm.component.commonUtil.bytes.BytesUtil;




/**
 * CMPP_CONNECT
 * 
 * <p>
 * 参照：中国移动通信互联网短信网关接口协议CMPP3.0, 中国移动通信互联网短信网关接口协议CMPP2.0
 * </p>
 *
 * @author	Wang Shenggong
 * @version 1.0.0
 * @since 1.0.0
 *
 */
public class CmppConnectPacket extends CmppPacket {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 源地址, 此处为SP_Id, 即SP的企业代码
	 */
	private String sourceAddr;
	
	/**
	 * 用于鉴别源地址。其值通过单向MD5 hash计算得出，表示如下： 
	 * AuthenticatorSource =MD5（Source_Addr+9 字节的0 +shared secret+timestamp） 
	 * Shared secret 由中国移动与源地址实体事先商定，timestamp格式为：MMDDHHMMSS，即月日时分秒，10位。
	 */
	private byte[] authenticatorSource;
	
	/**
	 * 时间戳的明文,由客户端产生,格式为MMDDHHMMSS，即月日时分秒，10位数字的整型，右对齐 。
	 */
	private int timestamp;
	private int ver;

	public CmppConnectPacket(){
		commandId = CmppPacket.CMPP_CONNECT;
		totalLength = CmppPacket.CMPP_CONNECT_LENGTH;
	}
	
	/**
	 * 构造CMPP_CONNECT包
	 */
	public CmppConnectPacket(Version version){
		super(version);
		
		commandId = CmppPacket.CMPP_CONNECT;
		totalLength = CmppPacket.CMPP_CONNECT_LENGTH;
	}
	
	public byte[] pack()  throws PacketException{
		super.pack();
		
		try {
			putStringRightPad(sourceAddr, 6);
			put(authenticatorSource, 0 , 16);
			putInt(version.getVersion());
			putInt(timestamp);
		} catch (Exception e) {
			throw new PacketException("Unexpected Exception on packing CmppConnectPacket: TotalLength=" + totalLength + ", CommandId=" + Integer.toHexString(commandId) + ", SequenceId=" + sequenceId, e);
		}
		
		return getBytes();
	}

	public CmppPacket unpack(ByteBuffer buffer) throws PacketException{
		
		super.unpack(buffer);
		
		sourceAddr = getString(6);
		
		authenticatorSource = new byte[16];
		get(authenticatorSource);
		
		ver = get();
		version = Version.toVersion(ver);			
		timestamp = getInt();
		
		return this;
	}

	/**
	 * @return 源地址
	 */
	public String getSourceAddr() {
		return sourceAddr;
	}

	/**
	 * 设置源地址
	 * 
	 * @param sourceAddr the sourceAddr to set
	 */
	public void setSourceAddr(String sourceAddr) {
		this.sourceAddr = sourceAddr;
	}

	/**
	 * @return the authenticatorSource
	 */
	public byte[] getAuthenticatorSource() {
		return authenticatorSource;
	}

	/**
	 * @param authenticatorSource the authenticatorSource to set
	 */
	public void setAuthenticatorSource(byte[] authenticatorSource) {
		this.authenticatorSource = authenticatorSource;
	}
	
	/**
	 * @return the timestamp
	 */
	public int getTimestamp() {
		return timestamp;
	}

	/**
	 * @param timestamp the timestamp to set
	 */
	public void setTimestamp(int timestamp) {
		this.timestamp = timestamp;
	}
	
	/**
	 * 取得authenticatorSource的十六进制字符串
	 * @return authenticatorSource
	 */
	public String getAuthenticatorSourceHexString(){
		return BytesUtil.bytes2hex(authenticatorSource);
	}
	
	/**
	 * 取得连接使用的协议版本信息
	 * @return
	 */
	public Version getVersion(){
		return version;
	}
	
	public int getVer() {
		return ver;
	}

	public void setVer(int ver) {
		this.ver = ver;
	}

	public String toString(){
		StringBuffer sb = new StringBuffer();
		
		sb.append("CMPP_CONNECT:");
		sb.append("Sequence_Id=").append(sequenceId);
		
		sb.append(",Source_Addr=").append(sourceAddr);
		sb.append(",AuthenticatorSource=").append(getAuthenticatorSourceHexString());
		sb.append(",Version=").append(version.getDescription());
		sb.append(",Timestamp=").append(timestamp);
		
		return sb.toString();
	}
	
	
	
	
	
	
}
