/*
 * @ (#) CmppActiveTestRespPacket.java Jun 8, 2008
 *
 * 
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import java.nio.ByteBuffer;



/**
 * CMPP_ACTIVE_TEST_RESP
 * 
 * <p>
 * 参照：中国移动通信互联网短信网关接口协议CMPP3.0, 中国移动通信互联网短信网关接口协议CMPP2.0
 * </p>
 *
 * @author	Wang Shenggong
 * @version 1.0.0
 * @since 1.0.0
 *
 */
public class CmppActiveTestRespPacket extends CmppPacket {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 返回消息
	 */
	private byte reserved = 0x00;
	
	public CmppActiveTestRespPacket(){
		commandId = CmppPacket.CMPP_ACTIVE_TEST_RESP;
		totalLength = CmppPacket.CMPP_ACTIVE_TEST_RESP_LENGTH;
	}
	
	public byte[] pack() throws PacketException{
		super.pack();
		
		try {
			put(reserved);
		} catch (Exception e) {
			throw new PacketException("Unexpected Exception on packing CmppActiveTestRespPacket: TotalLength=" + totalLength + ", CommandId=" + Integer.toHexString(commandId) + ", SequenceId=" + sequenceId, e);
		}
		
		return getBytes();
	}

	public CmppPacket unpack(ByteBuffer buffer) throws PacketException{
		super.unpack(buffer);
		
		return this;
	}
	
	public void setReserved(byte reserved){
		this.reserved = reserved;
	}
	
	public byte getReserved(){
		return reserved;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		
		sb.append("CMPP_ACTIVE_TEST_RESP:");
		sb.append("Sequence_Id=").append(sequenceId);
		sb.append(",Reserved=").append(reserved);
		return sb.toString();
	}
}
