/*
 * @ (#) CmppActiveTestPacket.java Jun 8, 2008
 *
 * 
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import java.nio.ByteBuffer;



/**
 * CMPP_ACTIVE_TEST
 *	
 * <p>
 * 参照：中国移动通信互联网短信网关接口协议CMPP3.0, 中国移动通信互联网短信网关接口协议CMPP2.0
 * </p>
 * 
 * @author	WANG SHENGGONG
 * @version 1.0.0
 * @since 1.0.0
 *
 */
public class CmppActiveTestPacket extends CmppPacket {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 构造CMPP链路检测封包
	 */
	public CmppActiveTestPacket(){
		commandId = CmppPacket.CMPP_ACTIVE_TEST;
		totalLength = CmppPacket.CMPP_ACTIVE_TEST_LENGTH;
	}
	
	public byte[] pack()  throws PacketException{
		return super.pack();
	}

	public CmppPacket unpack(ByteBuffer buffer)  throws PacketException{
		super.unpack(buffer);
		return this;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		
		sb.append("CMPP_ACTIVE_TEST:");
		sb.append("Sequence_Id=").append(sequenceId);
		
		return sb.toString();
	}
}
