package com.aspire.nm.component.cmppserver.filter;


import javax.annotation.Resource;

import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.springframework.stereotype.Service;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitRespPacket;
import com.aspire.nm.component.cmppserver.runTime.Connection;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;

@Service
public class CountFilter extends IoFilterAdapter {
	
	
	@Resource
	private SysRunTimeService sysRunTimeService;
	
	public void messageReceived(NextFilter nextFilter, IoSession session, Object message) throws Exception {
    	if(message instanceof CmppSubmitPacket){
    		
    		sysRunTimeService.getMoMtCounter().getMtCounter().increment();
    		
    		UserRunTime userRunTime = sysRunTimeService.getUserRunTime(session);
    		userRunTime.getMoMtCounter().getMtCounter().increment();
    		
    		Connection connection = userRunTime.getConnection(session);
    		connection.getMoMtCounter().getMtCounter().increment();
    	}
    	
    	if(message instanceof CmppDeliverRespPacket){
    		sysRunTimeService.getMoMtCounter().getMoReportRespCounter().increment();
    		
    		UserRunTime userRunTime = sysRunTimeService.getUserRunTime(session);
    		userRunTime.getMoMtCounter().getMoReportRespCounter().increment();
    		
    		Connection connection = userRunTime.getConnection(session);
    		connection.getMoMtCounter().getMoReportRespCounter().increment();
    	}
    	nextFilter.messageReceived(session, message);
    }
	
	public void messageSent(NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
		if(writeRequest.getMessage() instanceof CmppSubmitRespPacket){
			int result = ((CmppSubmitRespPacket)writeRequest.getMessage()).getResult();
			if(result== CmppSubmitRespPacket.RESULT_OK){
				sysRunTimeService.getMoMtCounter().getMtRespSucessCounter().increment();
				
				UserRunTime userRunTime = sysRunTimeService.getUserRunTime(session);
	    		userRunTime.getMoMtCounter().getMtRespSucessCounter().increment();
	    		
	    		Connection connection = userRunTime.getConnection(session);
	    		connection.getMoMtCounter().getMtRespSucessCounter().increment();
			}else{
				sysRunTimeService.getMoMtCounter().getMtRespFailCounter().increment(CmppSubmitRespPacket.FailDetailMap.get(result));
				
				UserRunTime userRunTime = sysRunTimeService.getUserRunTime(session);
	    		userRunTime.getMoMtCounter().getMtRespFailCounter().increment(CmppSubmitRespPacket.FailDetailMap.get(result));
	    		
	    		Connection connection = userRunTime.getConnection(session);
	    		connection.getMoMtCounter().getMtRespFailCounter().increment(CmppSubmitRespPacket.FailDetailMap.get(result));
			}
    	}
		nextFilter.messageSent(session, writeRequest);
    }
}

