package com.aspire.nm.component.cmppserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

import com.aspire.nm.component.cmppserver.filter.AdressFilter;
import com.aspire.nm.component.cmppserver.plugins.ProcessSubmit;
import com.aspire.nm.component.cmppserver.runTime.RunTimeInfoBuilder;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;
import com.aspire.nm.component.cmppserver.server.CmppAcceptor;

public class CmppServer implements InitializingBean{
    
    @Resource
    private RunTimeInfoBuilder runTimeInfoBuilder;
	@Resource
	private SysRunTimeService sysRunTimeService;
	@Resource 
	private CmppAcceptor cmppAcceptor;
	@Resource
    private AdressFilter adressFilter;
	
	
	@Value("${processSubmitImplClassName}")
    private String processSubmitImplClassName;
	
	private ProcessSubmit processSubmit;
    public ProcessSubmit getProcessSubmit() {
        return processSubmit;
    }
    public void setProcessSubmit(ProcessSubmit processSubmit) {
        this.processSubmit = processSubmit;
    }


    @Override
    public void afterPropertiesSet() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
	    if(!StringUtils.isEmpty(processSubmitImplClassName)){
	        processSubmit = (ProcessSubmit) Class.forName(processSubmitImplClassName).newInstance();
	    }
    }
    
    
    public void start() throws IOException{
        try {
            Class.forName("com.aspire.nm.component.cmppserver.util.InvokeRateUtil");
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        
        cmppAcceptor.start();
    }
    public void stop() throws IOException{
        cmppAcceptor.stop();
    }
	
    
    
    
    
    
    
    
    
	/**
	 * 增加全局黑名单
	 * @param blackIps
	 * @throws UnknownHostException
	 */
	public void addBlackIps(List<String> blackIps) throws UnknownHostException{
	    for(String blackIp : blackIps){
	        adressFilter.add(InetAddress.getByName(blackIp));
	    }
	}
	/**
	 * 获取CmppServer运行信息
	 * @return
	 */
	public String getRunTimeInfo(){
	    try {
            return runTimeInfoBuilder.build();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
	}
	/**
     * 
     * @param clientConfig 接入用户的配置信息
     * @return
     * @throws UnknownHostException
	 * @throws ClassNotFoundException 
	 * @throws IllegalAccessException 
	 * @throws InstantiationException 
     */
	public CmppServer addClientConfig(ClientConfig clientConfig) 
	        throws UnknownHostException, InstantiationException, IllegalAccessException, ClassNotFoundException{
	    if(clientConfig.getUsername().length() > 6){
	        throw new RuntimeException("username.length > 6 , username = " + clientConfig.getUsername());
	    }
	    if(sysRunTimeService.getClientConfig(clientConfig.getUsername()) != null){
	        return this;
	    }
	    sysRunTimeService.addClientConfig(clientConfig.getUsername(), clientConfig);
        return this;
    }
	
	/**
	 * 删除用户接入
	 * @param user
	 */
	public void removeClientConfig(String user) {
	    sysRunTimeService.removeClientConfig(user);
	}
            
	/**
	 * 获取userRunTime
	 * @param user
	 * @return
	 */
	public UserRunTime getUserRunTime(String user){
	    return sysRunTimeService.getUserRunTime(user);
	}
	
	
}
