/*
 * Decompiled with CFR 0.152.
 */
package net.orivis.shared.scopes.service;

import java.util.Date;
import java.util.Objects;
import net.orivis.shared.annotations.DataRetrieverDescription;
import net.orivis.shared.annotations.DeleteStrategy;
import net.orivis.shared.config.WebContext;
import net.orivis.shared.exceptions.ItemForAddContainsIdException;
import net.orivis.shared.exceptions.ItemNotFoundException;
import net.orivis.shared.model.IDPresenter;
import net.orivis.shared.postgres.service.PaginationService;
import net.orivis.shared.repository.AbstractDataFilter;
import net.orivis.shared.scopes.form.ScopeForm;
import net.orivis.shared.scopes.model.ScopeModel;
import net.orivis.shared.scopes.repository.ScopeRepo;
import org.springframework.stereotype.Service;

@Service
@DataRetrieverDescription(model=ScopeModel.class, form=ScopeForm.class, repo=ScopeRepo.class)
@DeleteStrategy(value=2)
public class ScopeService
extends PaginationService<ScopeModel> {
    public ScopeService(WebContext holder) {
        super(holder);
    }

    public ScopeModel preAdd(ScopeModel object) throws ItemForAddContainsIdException {
        object.setDate(new Date());
        return (ScopeModel)super.preAdd((IDPresenter)object);
    }

    public ScopeModel findByName(String name, Long userData, boolean fullAccess) {
        if (name == null) {
            throw new ItemNotFoundException("global.scope.cannot_be_null_in_request");
        }
        AbstractDataFilter filter = this.getFilterImpl().eq("name", (Object)name).and(this.getNotDeletedQuery());
        if (!fullAccess && Objects.nonNull(this.addSelfSpecWithUserScopes(userData))) {
            filter.and(this.addSelfSpecWithUserScopes(userData));
        }
        return (ScopeModel)((Object)this.getRepository().filteredOne(filter).orElseThrow(() -> new ItemNotFoundException(name)));
    }

    public AbstractDataFilter<ScopeModel> addSelfSpecWithUserScopes(Long userData) {
        return null;
    }
}

