/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.argument;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.argument.ArgumentType;
import net.orbyfied.j8.command.argument.GenericTypeInstance;
import net.orbyfied.j8.command.argument.TypeIdentifier;
import net.orbyfied.j8.util.StringReader;

public abstract class GenericArgumentType<B>
implements ArgumentType<B> {
    final ArrayList<String> parameters;

    public GenericArgumentType(List<String> params) {
        this.parameters = new ArrayList<String>(params);
    }

    public GenericArgumentType(String ... params) {
        this(Arrays.asList(params));
    }

    public Class<B> getBaseType() {
        return this.getType();
    }

    public TypeIdentifier getGenericIdentifier(LinkedHashMap<String, ArgumentType<?>> typeParams) {
        TypeIdentifier id = this.getBaseIdentifier().clone();
        for (ArgumentType<?> pt : typeParams.values()) {
            id.getTypeParameters().add(pt.getIdentifier());
        }
        return id;
    }

    public List<String> getTypeParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String getTypeParameter(int i) {
        return this.parameters.get(i);
    }

    @Override
    public TypeIdentifier getIdentifier() {
        return this.getBaseIdentifier();
    }

    @Override
    public boolean accepts(Context context, StringReader reader) {
        throw new IllegalArgumentException("Raw use of parameterized type " + this.getBaseIdentifier());
    }

    @Override
    public B parse(Context context, StringReader reader) {
        throw new IllegalArgumentException("Raw use of parameterized type " + this.getBaseIdentifier());
    }

    @Override
    public void write(Context context, StringBuilder builder, B v) {
        throw new IllegalArgumentException("Raw use of parameterized type " + this.getBaseIdentifier());
    }

    @Override
    public void suggest(Context context, SuggestionAccumulator suggestions) {
        throw new IllegalArgumentException("Raw use of parameterized type " + this.getBaseIdentifier());
    }

    public GenericTypeInstance<B> instance(ArgumentType ... types) {
        return new GenericTypeInstance(this, types);
    }

    public GenericTypeInstance<B> instance(List<ArgumentType> types) {
        return new GenericTypeInstance(this, types);
    }

    public abstract boolean accepts(Context var1, StringReader var2, LinkedHashMap<String, ArgumentType> var3);

    public abstract B parse(Context var1, StringReader var2, LinkedHashMap<String, ArgumentType> var3);

    public abstract void write(Context var1, StringBuilder var2, B var3, LinkedHashMap<String, ArgumentType> var4);

    public abstract void suggest(Context var1, SuggestionAccumulator var2, LinkedHashMap<String, ArgumentType> var3);
}

