/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.NodeComponent;
import net.orbyfied.j8.command.argument.Argument;
import net.orbyfied.j8.command.argument.ArgumentType;
import net.orbyfied.j8.command.argument.Flag;
import net.orbyfied.j8.command.component.Executable;
import net.orbyfied.j8.command.component.Flags;
import net.orbyfied.j8.command.component.Functional;
import net.orbyfied.j8.command.component.NonComponent;
import net.orbyfied.j8.command.component.Primary;
import net.orbyfied.j8.command.component.Properties;
import net.orbyfied.j8.command.component.Secure;
import net.orbyfied.j8.command.impl.CommandNodeExecutor;
import net.orbyfied.j8.util.ReflectionUtil;
import net.orbyfied.j8.util.StringReader;

public class Node {
    protected final ArrayList<NodeComponent> components = new ArrayList();
    protected final HashMap<Class<?>, NodeComponent> componentsByClass = new HashMap();
    protected final ArrayList<Node> children = new ArrayList();
    protected final HashMap<String, Node> childrenByName = new HashMap();
    protected final HashMap<String, Node> fastMappedChildren = new HashMap();
    protected final String name;
    protected final List<String> aliases = new ArrayList<String>();
    protected final Node parent;
    protected Node root;

    public Node(String name, Node parent, Node root) {
        this.name = name;
        this.parent = parent;
        this.root = Objects.requireNonNullElse(root, this);
    }

    public List<Node> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Map<String, Node> getFastMappedChildren() {
        return Collections.unmodifiableMap(this.fastMappedChildren);
    }

    public List<NodeComponent> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public Map<Class<?>, NodeComponent> getComponentsByClass() {
        return Collections.unmodifiableMap(this.componentsByClass);
    }

    public Node parent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    public Node root() {
        return this.root;
    }

    public Node addAliases(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    public Node removeAlias(String ... aliases) {
        this.aliases.removeAll(Arrays.asList(aliases));
        return this;
    }

    public <T extends NodeComponent> T makeComponent(Function<Node, T> constructor) {
        return (T)this.addComponent((NodeComponent)constructor.apply(this));
    }

    public <T extends NodeComponent> Node makeComponent(Function<Node, T> constructor, Consumer<T> consumer) {
        NodeComponent it = this.addComponent((NodeComponent)constructor.apply(this));
        if (consumer != null) {
            consumer.accept(it);
        }
        return this;
    }

    public <T extends NodeComponent> T component(Class<T> tClass, Function<Node, T> constructor) {
        Object c = this.getComponent(tClass);
        if (c != null) {
            return c;
        }
        c = (NodeComponent)constructor.apply(this);
        this.addComponent(c);
        return c;
    }

    public <T extends NodeComponent> Node component(Class<T> tClass, Function<Node, T> constructor, BiConsumer<Node, T> consumer) {
        T c = this.component(tClass, constructor);
        if (consumer != null) {
            consumer.accept(this, (Node)c);
        }
        return this;
    }

    public <T extends NodeComponent> T addComponent(T component) {
        Objects.requireNonNull(component, "component cannot be null");
        this.components.add(component);
        ReflectionUtil.walkParents(component.getClass(), c -> !c.isAssignableFrom(NonComponent.class), c -> this.componentsByClass.put((Class<?>)c, component));
        return component;
    }

    public <T extends NodeComponent> Node addComponent(T component, Consumer<T> consumer) {
        T c = this.addComponent(component);
        if (consumer != null) {
            consumer.accept(c);
        }
        return this;
    }

    public Node removeComponent(NodeComponent component) {
        this.components.remove(component);
        ReflectionUtil.walkParents(component.getClass(), c -> !c.isAssignableFrom(NonComponent.class), c -> this.componentsByClass.remove(c, component));
        return this;
    }

    public Node removeComponent(Class<?> klass) {
        return this.removeComponent(this.componentsByClass.get(klass));
    }

    public <T> T getComponentOf(Class<T> klass) {
        return (T)this.componentsByClass.get(klass);
    }

    public <T extends NodeComponent> T getComponent(Class<T> klass) {
        return (T)this.componentsByClass.get(klass);
    }

    public boolean hasComponentOf(Class<?> klass) {
        return this.componentsByClass.containsKey(klass);
    }

    public Node addChild(Node node) {
        Objects.requireNonNull(node, "node cannot be null");
        this.children.add(node);
        this.childrenByName.put(node.name, node);
        if (node.componentsByClass.containsKey(Executable.class)) {
            this.fastMappedChildren.put(node.name, node);
        }
        return node;
    }

    public Node addChild(Node node, Consumer<Node> consumer) {
        consumer.accept(this.addChild(node));
        return this;
    }

    public Node removeChild(Node node) {
        this.children.remove(node);
        this.childrenByName.remove(node.getName());
        if (node.componentsByClass.containsKey(Executable.class)) {
            this.fastMappedChildren.remove(node.name);
        }
        return this;
    }

    public Node getChildByName(String name) {
        return this.childrenByName.get(name);
    }

    public Node getChildByPath(String ... path) {
        Node curr = this;
        for (String p : path) {
            curr = curr.getChildByName(p);
        }
        return curr;
    }

    public Node getSubnode(String name) {
        return this.childrenByName.get(name);
    }

    public Node getOrCreateSubnode(String name, Function<Node, Node> constructor) {
        Node node = this.getSubnode(name);
        if (node != null) {
            return node;
        }
        node = constructor.apply(this);
        this.addChild(node);
        return node;
    }

    public Primary getNextSubnode(Context ctx, StringReader reader) {
        if (reader.current() == '\uffff') {
            return null;
        }
        Node node = this.fastMappedChildren.get(reader.branch().collect(c -> c.charValue() != ' '));
        if (node != null) {
            return node.getComponentOf(Primary.class);
        }
        for (Node child : this.children) {
            Primary sel = child.getComponentOf(Primary.class);
            if (!sel.selects(ctx, reader.branch())) continue;
            return sel;
        }
        return null;
    }

    public Node processWalked(Context context, StringReader reader) {
        for (NodeComponent component : this.components) {
            if (component instanceof Primary || !(component instanceof Functional)) continue;
            Functional fc = (Functional)component;
            fc.walked(context, reader);
        }
        return this;
    }

    public Node processExecute(Context context) {
        for (NodeComponent component : this.components) {
            if (component instanceof Primary || !(component instanceof Functional)) continue;
            Functional fc = (Functional)component;
            fc.execute(context);
        }
        return this;
    }

    public Node propertied(String desc, String label, String usage) {
        this.component(Properties.class, Properties::new, (node, rcp) -> rcp.description(desc).label(label).usage(usage));
        return this;
    }

    public Node executes(CommandNodeExecutor executor) {
        this.addComponent(new Executable(this)).setExecutor(executor);
        return this;
    }

    public Node executes(CommandNodeExecutor executor, CommandNodeExecutor walked) {
        this.addComponent(new Executable(this)).setExecutor(executor).setWalkExecutor(walked);
        return this;
    }

    public Node argument(ArgumentType<?> type) {
        this.addComponent(new Argument(this)).setType(type);
        return this;
    }

    public Node permission(String perm) {
        this.component(Secure.class, Secure::new, (node, secure) -> secure.setPermission(perm));
        return this;
    }

    public Node flag(Flag<?> flag) {
        this.component(Flags.class, Flags::new, (node, flags) -> flags.addFlag(flag));
        return this;
    }

    public Node flag(String name, Character ch, ArgumentType<?> type, boolean isSwitch) {
        this.component(Flags.class, Flags::new, (node, flags) -> flags.addFlag(name, ch, type, isSwitch));
        return this;
    }

    public Node flag(String name, ArgumentType<?> type) {
        this.component(Flags.class, Flags::new, (node, flags) -> flags.addFlag(name, null, type, false));
        return this;
    }

    public Node thenArgument(String name, ArgumentType<?> type) {
        Node node = new Node(name, this, this.root);
        node.argument(type);
        this.addChild(node);
        return node;
    }

    public Node thenArgument(String name, ArgumentType<?> type, BiConsumer<Node, Argument> consumer) {
        Node node = this.thenArgument(name, type);
        if (consumer != null) {
            consumer.accept(node, node.getComponent(Argument.class));
        }
        return this;
    }

    public Node thenExecute(String name, CommandNodeExecutor executor) {
        Node node = new Node(name, this, this.root);
        node.executes(executor);
        this.addChild(node);
        return node;
    }

    public Node thenExecute(String name, CommandNodeExecutor executor, CommandNodeExecutor walked) {
        Node node = new Node(name, this, this.root);
        node.executes(executor, walked);
        this.addChild(node);
        return node;
    }

    public void printTreeFancy(PrintStream stream) {
        this.printTreeFancyNext(stream, 0);
    }

    private void printTreeFancyNext(PrintStream stream, int depth) {
        if (depth >= 50) {
            System.out.println(" ".repeat(depth) + " /!\\ Tree goes too deep! Over 50 entries deep.");
            return;
        }
        Argument param = this.getComponent(Argument.class);
        if (param != null) {
            stream.println(" ".repeat(depth) + "\\" + this.name + " <" + param.getType().getIdentifier() + " " + param.getIdentifier() + ">");
        } else {
            stream.println(" ".repeat(depth) + "/" + this.name);
        }
        for (Node child : this.children) {
            child.printTreeFancyNext(stream, depth + 1);
        }
    }
}

