/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.argument.Argument;
import net.orbyfied.j8.command.argument.ArgumentTypes;
import net.orbyfied.j8.command.argument.Flag;
import net.orbyfied.j8.command.argument.TypeResolver;
import net.orbyfied.j8.command.component.Completer;
import net.orbyfied.j8.command.component.Executable;
import net.orbyfied.j8.command.component.Primary;
import net.orbyfied.j8.command.component.Suggester;
import net.orbyfied.j8.command.exception.CommandException;
import net.orbyfied.j8.command.exception.CommandHaltException;
import net.orbyfied.j8.command.exception.CommandParseException;
import net.orbyfied.j8.command.exception.ErrorLocation;
import net.orbyfied.j8.command.exception.NodeExecutionException;
import net.orbyfied.j8.command.exception.NodeParseException;
import net.orbyfied.j8.command.impl.DelegatingNamespacedTypeResolver;
import net.orbyfied.j8.util.StringReader;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public abstract class CommandManager {
    TypeResolver typeResolver;
    ArrayList<Node> commands = new ArrayList();
    HashMap<String, Node> aliases = new HashMap();

    public CommandManager() {
        this.typeResolver = new DelegatingNamespacedTypeResolver().namespace("system", ArgumentTypes.typeResolver);
    }

    public CommandManager register(Node command) {
        this.commands.add(command);
        this.aliases.put(command.getName(), command);
        for (String alias : command.aliases) {
            this.aliases.put(alias, command);
        }
        this.registerPlatform(command);
        return this;
    }

    public CommandManager unregister(Node command) {
        this.commands.remove(command);
        this.aliases.remove(command.getName(), command);
        for (String alias : command.aliases) {
            this.aliases.remove(alias, command);
        }
        this.unregisterPlatform(command);
        return this;
    }

    public CommandManager setTypeResolver(TypeResolver resolver) {
        this.typeResolver = resolver;
        return this;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    protected abstract void registerPlatform(Node var1);

    protected abstract void unregisterPlatform(Node var1);

    public abstract void enablePlatform();

    public abstract void disablePlatform();

    public Context dispatch(CommandSender sender, String str, SuggestionAccumulator suggestions, Consumer<Context> ctxConsumer) {
        Context context;
        block47: {
            boolean isSuggesting = suggestions != null;
            Context.Target target = isSuggesting ? Context.Target.SUGGEST : Context.Target.EXECUTE;
            StringReader reader = new StringReader(str, 0);
            context = new Context(this, sender);
            context.target(target);
            if (ctxConsumer != null) {
                ctxConsumer.accept(context);
            }
            context.successful(true);
            String alias = reader.collect(c -> c.charValue() != ' ', 0);
            Node root = this.aliases.get(alias);
            if (root == null) {
                return null;
            }
            context.rootCommand = root;
            context.reader = reader;
            try {
                Executable lastExecutable = null;
                Primary primary = root.getComponentOf(Primary.class);
                Suggester suggester = null;
                Node current = root;
                Node last = root;
                int i = 0;
                System.out.println();
                while (true) {
                    Suggester tempSuggester;
                    last = current;
                    ++i;
                    context.current = current;
                    context.currentExecutable = lastExecutable;
                    char pc = reader.current();
                    System.out.println("pc: '" + pc + "' @ " + reader.index());
                    if (primary != null) {
                        primary.getNode().processWalked(context, reader);
                    }
                    if (primary instanceof Executable) {
                        Executable exec;
                        lastExecutable = exec = (Executable)primary;
                        try {
                            exec.walked(context, reader);
                        }
                        catch (Exception e) {
                            if (e instanceof CommandException) {
                                throw (RuntimeException)e;
                            }
                            throw new NodeExecutionException(root, current, (Throwable)e);
                        }
                    } else if (primary instanceof Argument) {
                        Argument param = (Argument)primary;
                        param.walked(context, reader);
                    }
                    while (reader.peek(1) == '-') {
                        Flag<?> flag;
                        int sidx = reader.index();
                        if (reader.next(2) == '-') {
                            reader.next();
                            String flagName = reader.collect(c -> c.charValue() != '=' && c.charValue() != ' ');
                            flag = context.flagsByName.get(flagName);
                            if (flag == null) {
                                if (!isSuggesting) {
                                    throw new CommandParseException(root, new ErrorLocation(reader, sidx + 1, reader.index()), "Flag --" + flagName + " was not found.");
                                }
                                for (Flag<?> f : context.flags) {
                                    if (f.isSwitch()) {
                                        suggestions.suggest("--" + f.getName());
                                        continue;
                                    }
                                    suggestions.suggest("--" + f.getName() + "=");
                                }
                                reader.collect(c -> c.charValue() != ' ');
                                continue;
                            }
                            if (reader.current() == '=') {
                                reader.next();
                                if (!isSuggesting) {
                                    Object val = flag.getType().parse(context, reader);
                                    context.flagValues.put(flag, val);
                                    continue;
                                }
                                suggestions.pushPrefix("--" + flagName + "=");
                                flag.getType().suggest(context, suggestions);
                                suggestions.popPrefix();
                                continue;
                            }
                            if (!flag.isSwitch()) {
                                throw new CommandParseException(root, new ErrorLocation(reader, sidx + 1, reader.index()), "Flag --" + flagName + " is not a switch, but no value was provided.");
                            }
                            context.flagValues.put(flag, true);
                            continue;
                        }
                        if (!isSuggesting) {
                            char c2;
                            while ((c2 = reader.current()) != ' ' && c2 != '\uffff') {
                                flag = context.flagsByChar.get(Character.valueOf(c2));
                                if (flag == null) {
                                    throw new CommandParseException(root, new ErrorLocation(reader, sidx + 1, reader.index()), "Flag -" + c2 + " (switch) was not found.");
                                }
                                if (!flag.isSwitch()) {
                                    throw new CommandParseException(root, new ErrorLocation(reader, sidx + 1, reader.index()), "Flag -" + c2 + " is not a switch, but no value was provided.");
                                }
                                context.flagValues.put(flag, true);
                            }
                            continue;
                        }
                        for (Map.Entry<Character, Flag<?>> entry : context.flagsByChar.entrySet()) {
                            suggestions.suggest("-" + entry.getKey());
                        }
                    }
                    if (isSuggesting && (tempSuggester = current.getComponentOf(Suggester.class)) != null) {
                        suggester = tempSuggester;
                    }
                    reader.collect(c -> c.charValue() == ' ');
                    int idx = reader.index();
                    char cb = reader.current();
                    if (reader.current() == '\uffff') {
                        if (pc != '\uffff') break;
                        current = null;
                        break;
                    }
                    primary = current.getNextSubnode(context, reader);
                    if (!isSuggesting && primary == null) {
                        throw new NodeParseException(root, current, new ErrorLocation(reader, idx - 1, reader.index()), "Unknown subcommand.");
                    }
                    System.out.println("I " + i + " | primary-component: " + primary + ", node: " + (primary == null ? "<null>" : primary.getNode().getName()) + ", char: '" + reader.current() + "' (@ " + reader.index() + ")");
                    if (primary == null) {
                        current = null;
                        break;
                    }
                    current = primary.getNode();
                }
                if (isSuggesting) {
                    System.out.println("current: " + (current != null ? current.getName() : "<null>") + ", last: " + (last != null ? last.getName() : "<null>") + ", char: '" + reader.current() + "' (@ " + reader.index() + ")");
                    if (current == null || reader.prev() == ' ') {
                        Suggester sug = last.getComponent(Suggester.class);
                        if (sug == null) {
                            for (Node child : last.getChildren()) {
                                Completer comp = child.getComponent(Completer.class);
                                if (comp == null) continue;
                                comp.complete(context, suggestions, reader.branch());
                            }
                        } else {
                            sug.suggest(context, suggestions, reader.branch());
                        }
                    } else {
                        Completer comp = current.getComponent(Completer.class);
                        if (comp != null) {
                            comp.complete(context, suggestions, reader.branch());
                        }
                    }
                }
                if (lastExecutable == null || isSuggesting || !context.successful().booleanValue()) break block47;
                try {
                    lastExecutable.getNode().processExecute(context);
                    lastExecutable.execute(context);
                }
                catch (Exception e) {
                    if (e instanceof CommandException) {
                        throw (RuntimeException)e;
                    }
                    throw new NodeExecutionException(root, lastExecutable.node, (Throwable)e);
                }
            }
            catch (CommandException e) {
                if (e instanceof CommandHaltException) {
                    CommandHaltException ec = (CommandHaltException)e;
                    boolean success = ec.isSuccessful();
                    if (ec.getMessage() != null || ec.getCause() != null) {
                        StringBuilder b = new StringBuilder();
                        if (success) {
                            b.append(ChatColor.GREEN + ChatColor.BOLD + "\u2714 " + ChatColor.GREEN);
                        } else {
                            b.append(ChatColor.RED + ChatColor.BOLD + "\u2716 " + ChatColor.RED);
                        }
                        if (ec.getMessage() != null) {
                            b.append(ec.getMessage());
                        }
                        if (ec.getCause() != null) {
                            b.append(ChatColor.DARK_GRAY).append(" (").append(ChatColor.RED).append(ec.getCause()).append(ChatColor.DARK_GRAY).append(")");
                        }
                        context.intermediateText(b.toString());
                    }
                    context.successful(success);
                }
                if (e.isSevere()) {
                    e.printStackTrace();
                }
                context.intermediateText(e.getFormattedString());
                context.successful(false);
            }
        }
        return context;
    }

    public Node command(String name) {
        Node node;
        node.root = node = new Node(name, null, null);
        this.register(node);
        return node;
    }
}

