/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.exception;

import net.md_5.bungee.api.ChatColor;
import net.orbyfied.j8.util.StringReader;

public class ErrorLocation {
    protected StringReader reader;
    protected int fromIndex;
    protected int toIndex;

    public ErrorLocation(StringReader reader, int fromIndex, int toIndex) {
        this.reader = reader;
        if (fromIndex > toIndex) {
            toIndex = fromIndex = toIndex;
        }
        this.fromIndex = Math.min(reader.getString().length() - 1, fromIndex);
        this.toIndex = Math.max(reader.getString().length() - 1, toIndex);
    }

    public int getStartIndex() {
        return this.fromIndex;
    }

    public int getEndIndex() {
        return this.toIndex;
    }

    public StringReader getReader() {
        return this.reader;
    }

    public String getLocationString() {
        return this.getLocationString(6, 6);
    }

    public String getLocationString(int prevStart, int prevEnd) {
        StringBuilder b = new StringBuilder();
        b.append(ChatColor.GREEN).append("...");
        b.append(ChatColor.GRAY).append("[").append(this.getStartIndex()).append(":").append(this.getEndIndex()).append("]").append(" ");
        String str = this.reader.getString();
        int maxIdx = str.length() - 1;
        int startIndex0 = Math.max(Math.min(this.getStartIndex(), maxIdx), 0);
        int endIndex0 = Math.max(Math.min(this.getEndIndex(), maxIdx), 0);
        int startIndex = Math.min(startIndex0, endIndex0);
        int endIndex = Math.max(startIndex0, endIndex0);
        int pStartIndex = Math.max(Math.min(startIndex - prevStart, maxIdx), 0);
        int pEndIndex = Math.max(Math.min(endIndex + prevEnd, maxIdx), 0);
        String subPrefix = str.substring(pStartIndex, startIndex);
        String sub = str.substring(startIndex, endIndex);
        String subSuffix = str.substring(endIndex, pEndIndex);
        b.append(ChatColor.GREEN).append(subPrefix);
        b.append(ChatColor.RED).append(ChatColor.UNDERLINE).append(sub);
        b.append(ChatColor.GREEN).append(subSuffix);
        b.append(ChatColor.GREEN).append("...");
        return b.toString();
    }
}

