/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.argument;

import java.util.ArrayList;
import java.util.Objects;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.StringReader;

public class TypeIdentifier
extends Identifier
implements Cloneable {
    private ArrayList<TypeIdentifier> typeParams = new ArrayList();

    public static TypeIdentifier parse(String in, TypeIdentifier out) {
        char c2;
        Identifier.parse((String)in, (Identifier)out);
        StringReader reader = new StringReader(in, 0);
        reader.collect(c -> c.charValue() != '<');
        if (reader.next() == '\uffff') {
            return out;
        }
        while ((c2 = reader.current()) != '>' && c2 != '\uffff') {
            TypeIdentifier ident = new TypeIdentifier(null, null);
            String s = reader.collect(c1 -> c1.charValue() != ',');
            TypeIdentifier.parse(s, ident);
            out.typeParams.add(ident);
        }
        return out;
    }

    public static TypeIdentifier of(String in) {
        return TypeIdentifier.parse(in, new TypeIdentifier(null, null));
    }

    public TypeIdentifier(String namespace, String path) {
        super(namespace, path);
    }

    public ArrayList<TypeIdentifier> getTypeParameters() {
        return this.typeParams;
    }

    public TypeIdentifier clone() {
        try {
            return (TypeIdentifier)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(super.toString());
        if (this.typeParams.size() == 0) {
            return b.toString();
        }
        b.append("<");
        int l = this.typeParams.size();
        for (int i = 0; i < l; ++i) {
            if (i != 0) {
                b.append(", ");
            }
            TypeIdentifier param = this.typeParams.get(i);
            b.append(param);
        }
        return b.append(">").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeIdentifier that = (TypeIdentifier)o;
        return Objects.equals(this.typeParams, that.typeParams);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.typeParams);
    }
}

