/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command;

import java.util.Stack;

public abstract class SuggestionAccumulator {
    final Stack<String> prefixStack = new Stack();
    final Stack<String> suffixStack = new Stack();

    public SuggestionAccumulator suggest(Object o) {
        if (o == null) {
            return this;
        }
        StringBuilder str = new StringBuilder(o.toString());
        for (String prefix : this.prefixStack) {
            str.insert(0, prefix);
        }
        for (String suffix : this.suffixStack) {
            str.append(suffix);
        }
        this.suggest0(str.toString());
        return this;
    }

    protected abstract void suggest0(String var1);

    protected abstract void unsuggest0(String var1);

    public SuggestionAccumulator pushPrefix(String s) {
        this.prefixStack.push(s);
        return this;
    }

    public SuggestionAccumulator popPrefix() {
        this.prefixStack.pop();
        return this;
    }

    public SuggestionAccumulator pushSuffix(String s) {
        this.suffixStack.push(s);
        return this;
    }

    public SuggestionAccumulator popSuffix() {
        this.suffixStack.pop();
        return this;
    }
}

