/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.mc;

import java.lang.reflect.Field;
import java.util.Objects;
import net.orbyfied.j8.util.TextFormatting;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;

public class MetaBuilder<V extends ItemMeta, Self extends MetaBuilder<V, ?>> {
    protected V it;

    public static <T extends ItemMeta> T makeFor(Material material) {
        return (T)Bukkit.getItemFactory().getItemMeta(Objects.requireNonNullElse(material, Material.AIR));
    }

    public static <T extends ItemMeta> MetaBuilder<T, MetaBuilder<T, ?>> create(Material material) {
        return MetaBuilder.of(MetaBuilder.makeFor(material));
    }

    public static <T extends ItemMeta> MetaBuilder<T, MetaBuilder<T, ?>> create() {
        return MetaBuilder.create(Material.AIR);
    }

    public static <T extends ItemMeta> MetaBuilder<T, MetaBuilder<T, ?>> create(T it) {
        return new MetaBuilder(it.clone());
    }

    public static <T extends ItemMeta> MetaBuilder<T, MetaBuilder<T, ?>> of(T it) {
        return new MetaBuilder(it);
    }

    protected MetaBuilder(V it) {
        this.it = it;
    }

    final Self self(Runnable runnable) {
        runnable.run();
        return (Self)this;
    }

    public V get() {
        return this.it;
    }

    public Self setProperty(String name, Object o) {
        try {
            Field f = this.it.getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(this.it, o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (Self)this;
    }

    public <T> T getProperty(String name) {
        try {
            Field f = this.it.getClass().getDeclaredField(name);
            f.setAccessible(true);
            return (T)f.get(this.it);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Self setDisplayName(String name) {
        return this.self(() -> this.it.setDisplayName(TextFormatting.translate(name, "&", "&#")));
    }

    public String getDisplayName() {
        return this.it.getDisplayName();
    }

    public Self setUnbreakable(boolean v) {
        return this.self(() -> this.it.setUnbreakable(v));
    }

    public boolean isUnbreakable() {
        return this.it.isUnbreakable();
    }

    public Self empty() {
        this.it.setDisplayName("");
        this.it.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DYE, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_POTION_EFFECTS});
        return (Self)this;
    }
}

