/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.registry;

import java.util.function.Function;
import net.orbyfied.j8.registry.Identifiable;
import net.orbyfied.j8.registry.Registry;

public abstract class RegistryComponent<R extends Registry<T>, T extends Identifiable, K, V> {
    protected final R registry;
    protected Function<T, K> keyFactory;
    protected Function<T, V> valFactory;
    protected Function<V, K> valKeyFactory;

    public RegistryComponent(R registry) {
        this.registry = registry;
    }

    public R getRegistry() {
        return this.registry;
    }

    public abstract Class<K> getKeyType();

    public abstract Class<V> getValueType();

    public abstract boolean isLinear();

    public abstract boolean isMapped();

    public Function<T, K> getKeyFactory() {
        return this.keyFactory;
    }

    public Function<T, V> getValueFactory() {
        return this.valFactory;
    }

    public Function<V, K> getKeyFromValueFactory() {
        return this.valKeyFactory;
    }

    public K getKeyFromValue(V val) {
        return this.getKeyFromValueFactory().apply(val);
    }

    public V getValueOf(T t) {
        return this.getValueFactory().apply(t);
    }

    public K getKeyOf(T t) {
        return this.getKeyFactory().apply(t);
    }

    public abstract V getLinear(int var1);

    public abstract V getMapped(K var1);

    public V getMapped(T key) {
        return this.getMapped((T)this.keyFactory.apply(key));
    }

    public abstract RegistryComponent<R, T, K, V> register(V var1);

    public RegistryComponent<R, T, K, V> register(T item) {
        return this.register((T)this.getValueFactory().apply(item));
    }

    public abstract RegistryComponent<R, T, K, V> unregister(K var1);

    public RegistryComponent<R, T, K, V> unregister(T item) {
        return this.unregister((T)this.getKeyFactory().apply(item));
    }
}

