/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.minecraft;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.argument.ArgumentType;
import net.orbyfied.j8.command.argument.TypeIdentifier;
import net.orbyfied.j8.command.argument.TypeResolver;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.StringReader;
import net.orbyfied.j8.util.functional.TriConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MinecraftParameterType {
    public static final MinecraftTypeResolver typeResolver = new MinecraftTypeResolver();
    public static final ArgumentType<Player> ONLINE_PLAYER_DIRECT = MinecraftParameterType.of(Player.class, "minecraft:online_player_direct", (context, reader) -> true, (context, reader) -> {
        String s = reader.collect(c -> c.charValue() != ' ');
        Player player = Bukkit.getPlayer((String)s);
        if (player != null) {
            return player;
        }
        return Bukkit.getPlayer((UUID)UUID.fromString(s));
    }, (context, builder, s) -> builder.append(s.getUniqueId()), (context, suggestions) -> {
        for (Player player : Bukkit.getOnlinePlayers()) {
            suggestions.suggest(player.getName());
            suggestions.suggest(player.getUniqueId());
        }
    });

    private MinecraftParameterType() {
    }

    static <T> ArgumentType<T> of(final Class<T> klass, String baseId, final BiPredicate<Context, StringReader> acceptor, final BiFunction<Context, StringReader, T> parser, final TriConsumer<Context, StringBuilder, T> writer, final BiConsumer<Context, SuggestionAccumulator> suggester) {
        final TypeIdentifier bid = TypeIdentifier.of(baseId);
        ArgumentType type = new ArgumentType<T>(){

            @Override
            public TypeIdentifier getBaseIdentifier() {
                return bid;
            }

            @Override
            public Class<T> getType() {
                return klass;
            }

            @Override
            public boolean accepts(Context context, StringReader reader) {
                return acceptor.test(context, reader);
            }

            @Override
            public T parse(Context context, StringReader reader) {
                return parser.apply(context, reader);
            }

            @Override
            public void write(Context context, StringBuilder builder, T v) {
                writer.accept(context, builder, v);
            }

            @Override
            public void suggest(Context context, SuggestionAccumulator suggestions) {
                suggester.accept(context, suggestions);
            }

            public String toString() {
                return bid.toString();
            }
        };
        MinecraftParameterType.typeResolver.types.put(bid.getPath(), type);
        return type;
    }

    public static final class MinecraftTypeResolver
    implements TypeResolver {
        protected HashMap<String, ArgumentType<?>> types = new HashMap();

        @Override
        public ArgumentType<?> resolve(Identifier identifier) {
            return this.types.get(identifier.getPath());
        }
    }
}

