/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.orbyfied.j8.util.resource.ClassResourceResolver;

public interface ResourceResolver {
    public static final ResourceResolver FILE = new ResourceResolver(){

        @Override
        public URL getResourceFromPath(String path) throws MalformedURLException {
            return new File(path).toURL();
        }

        private Path pathOf(URL url) {
            return Path.of(url.getPath(), new String[0]);
        }

        @Override
        public boolean existsSafe(URL url) {
            return Files.exists(this.pathOf(url), new LinkOption[0]);
        }

        @Override
        public boolean isDirectorySafe(URL url) {
            return Files.isDirectory(this.pathOf(url), new LinkOption[0]);
        }

        @Override
        public OutputStream openOutputStream(URL url) throws IOException {
            return Files.newOutputStream(this.pathOf(url), new OpenOption[0]);
        }
    };

    public URL getResourceFromPath(String var1) throws MalformedURLException;

    public boolean existsSafe(URL var1);

    public boolean isDirectorySafe(URL var1);

    public OutputStream openOutputStream(URL var1) throws IOException;

    public static ResourceResolver inModule(Class<?> klass) {
        return new ClassResourceResolver(klass);
    }
}

