/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util;

import java.awt.Color;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class TextFormatting {
    public static final String NEWLINE_REGEX = Pattern.quote("\n");

    public static String translate(String text, String prefix, String hexprefix) {
        boolean enableHex = true;
        if (hexprefix == null) {
            enableHex = false;
        }
        if (prefix == null) {
            throw new IllegalArgumentException("colorcode prefix cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char current = text.charAt(i);
            int prefixEnd = Math.min(i + prefix.length(), text.length() - 1);
            int hexEnd = Math.min(i + (enableHex ? hexprefix.length() : 0), text.length() - 1);
            String prefixSpace = text.substring(i, prefixEnd);
            String hexSpace = enableHex ? text.substring(i, hexEnd) : "";
            char charAfterPrefix = text.charAt(prefixEnd);
            String x6 = "";
            if (enableHex) {
                x6 = text.substring(hexEnd, Math.min(i + 6 + hexprefix.length(), text.length()));
            }
            if (hexSpace.equals(hexprefix)) {
                if (!enableHex) {
                    builder.append(current);
                    continue;
                }
                builder.append(ChatColor.of((Color)new Color(Integer.parseInt(x6, 16))));
                i += hexprefix.length() + 6;
                continue;
            }
            if (prefixSpace.equals(prefix)) {
                builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)("&" + charAfterPrefix)));
                i += prefix.length() + 1;
                continue;
            }
            builder.append(current);
            ++i;
        }
        return builder.toString();
    }

    public static String rgbToHex(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        String out = "#" + Integer.toString(r, 16).toUpperCase() + Integer.toString(g, 16).toUpperCase() + Integer.toString(b, 16).toUpperCase();
        return out;
    }

    public static String gradient1d2fLr(String text, Color from, Color to, boolean checkForWhitespace, ChatColor ... formatting) {
        text = ChatColor.stripColor((String)text);
        int len = text.length();
        float p = 1.0f / (float)(len - 1);
        int r1 = from.getRed();
        int g1 = from.getGreen();
        int b1 = from.getBlue();
        int r2 = to.getRed();
        int g2 = to.getGreen();
        int b2 = to.getBlue();
        StringBuilder b = new StringBuilder();
        for (ChatColor color : formatting) {
            b.append(color);
        }
        String ef = b.toString();
        StringBuilder builder = new StringBuilder();
        float frame = 0.0f;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (checkForWhitespace && (c == ' ' || c == '\n' || c == '\t')) continue;
            Color col = TextFormatting.colInterpolate(r1, g1, b1, r2, g2, b2, frame);
            ChatColor color = ChatColor.of((Color)col);
            builder.append(color).append(ef).append(c);
            frame += p;
        }
        return builder.toString();
    }

    public static String gradient2d2fTlbr(String text, Color from, Color to, ChatColor ... formatting) {
        text = ChatColor.stripColor((String)text);
        String[] lines = text.split(NEWLINE_REGEX);
        int lenY = lines.length;
        float py = 1.0f / (float)(lenY - 1);
        int r1 = from.getRed();
        int g1 = from.getGreen();
        int b1 = from.getBlue();
        int r2 = to.getRed();
        int g2 = to.getGreen();
        int b2 = to.getBlue();
        StringBuilder b = new StringBuilder();
        for (ChatColor color : formatting) {
            b.append(color);
        }
        String ef = b.toString();
        StringBuilder builder = new StringBuilder();
        int ly = lines.length;
        float fy = 0.0f;
        for (int y = 0; y < ly; ++y) {
            String line = lines[y];
            int ll = line.length();
            float fx = 0.0f;
            float px = 1.0f / (float)(line.length() - 1);
            for (int i = 0; i < ll; ++i) {
                char c = line.charAt(i);
                float f = fx / 2.0f + fy / 2.0f;
                Color col = TextFormatting.colInterpolate(r1, g1, b1, r2, g2, b2, f);
                ChatColor color = ChatColor.of((Color)col);
                builder.append(color).append(ef).append(c);
                fx += px;
            }
            builder.append("\n");
            fy += py;
        }
        return builder.delete(builder.length() - 1, builder.length()).toString();
    }

    private static Color colInterpolate(int r1, int g1, int b1, int r2, int g2, int b2, float frame) {
        float iframe = 1.0f - frame;
        float r1f = (float)r1 * iframe;
        float g1f = (float)g1 * iframe;
        float b1f = (float)b1 * iframe;
        float r2f = (float)r2 * frame;
        float g2f = (float)g2 * frame;
        float b2f = (float)b2 * frame;
        float red = r1f + r2f;
        float green = g1f + g2f;
        float blue = b1f + b2f;
        return new Color(red / 255.0f, green / 255.0f, blue / 255.0f);
    }
}

