/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.parameter;

import java.util.LinkedHashMap;
import java.util.List;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.parameter.GenericParameterType;
import net.orbyfied.j8.command.parameter.ParameterType;
import net.orbyfied.j8.command.parameter.TypeIdentifier;
import net.orbyfied.j8.util.StringReader;

public class GenericTypeInstance<B>
implements ParameterType<B> {
    final LinkedHashMap<String, ParameterType> params = new LinkedHashMap();
    final GenericParameterType<B> base;

    public GenericTypeInstance(GenericParameterType<B> base, ParameterType ... types) {
        this.base = base;
        int l = types.length;
        if (l != base.getTypeParameters().size()) {
            throw new IllegalArgumentException("Invalid amount of type parameters.");
        }
        List<String> paramNames = base.getTypeParameters();
        for (int i = 0; i < l; ++i) {
            this.params.put(paramNames.get(i), types[i]);
        }
    }

    public GenericTypeInstance(GenericParameterType<B> base, List<ParameterType> types) {
        this.base = base;
        int l = types.size();
        if (l != base.getTypeParameters().size()) {
            throw new IllegalArgumentException("Invalid amount of type parameters.");
        }
        List<String> paramNames = base.getTypeParameters();
        for (int i = 0; i < l; ++i) {
            this.params.put(paramNames.get(i), types.get(i));
        }
    }

    public GenericParameterType<B> getBase() {
        return this.base;
    }

    @Override
    public TypeIdentifier getIdentifier() {
        TypeIdentifier id = this.getBaseIdentifier().clone();
        for (ParameterType pt : this.params.values()) {
            id.getTypeParams().add(pt.getIdentifier());
        }
        return id;
    }

    @Override
    public TypeIdentifier getBaseIdentifier() {
        return this.base.getBaseIdentifier();
    }

    @Override
    public Class<?> getType() {
        return this.base.getType();
    }

    @Override
    public boolean accepts(Context context, StringReader reader) {
        return this.base.accepts(context, reader, this.params);
    }

    @Override
    public B parse(Context context, StringReader reader) {
        return this.base.parse(context, reader, this.params);
    }

    @Override
    public void write(Context context, StringBuilder builder, B v) {
        this.base.write(context, builder, v, this.params);
    }

    @Override
    public void suggest(Context context, SuggestionAccumulator suggestions) {
        this.base.suggest(context, suggestions, this.params);
    }
}

