/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.ErrorLocation;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.exception.NodeParseException;
import net.orbyfied.j8.command.parameter.GenericParameterType;
import net.orbyfied.j8.command.parameter.ParameterType;
import net.orbyfied.j8.command.parameter.TypeIdentifier;
import net.orbyfied.j8.command.parameter.TypeResolver;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.StringReader;
import net.orbyfied.j8.util.functional.QuadConsumer;
import net.orbyfied.j8.util.functional.TriConsumer;
import net.orbyfied.j8.util.functional.TriFunction;
import net.orbyfied.j8.util.functional.TriPredicate;
import org.bukkit.util.Vector;

public class SystemParameterType {
    public static final SystemTypeResolver typeResolver = new SystemTypeResolver();
    public static final String KEY_PROVIDER_OPTION = "key_provider";
    private static final CompleterFunc BASE_10_COMPLETER_FUNC = (ctx, reader, acc) -> {
        String pre = reader.collect(c -> c.charValue() != ' ');
        for (int i = 0; i < 10; ++i) {
            acc.suggest(pre + i);
        }
    };
    private static final CompleterFunc BASE_10_F_COMPLETER_FUNC = (ctx, reader, acc) -> {
        String pre = reader.collect(c -> c.charValue() != ' ');
        String ext = "";
        if (!pre.contains(".")) {
            ext = ".";
        }
        for (int i = 0; i < 10; ++i) {
            acc.suggest(pre + i + ext);
        }
    };
    public static final ParameterType<Boolean> BOOLEAN = SystemParameterType.of(Boolean.class, "system:bool", (context, reader) -> reader.current() == '0' || reader.current() == '1' || reader.current() == 't' || reader.current() == 'f', (context, reader) -> {
        String str = reader.collect(c -> c.charValue() != ' ');
        return "1".equals(str) || "true".equals(str);
    }, (context, builder, value) -> builder.append(value), new Object[0]);
    public static final ParameterType<Byte> BYTE = SystemParameterType.of(Byte.class, "system:byte", (context, reader) -> SystemParameterType.isDigit(reader.current(), 10), (context, reader) -> SystemParameterType.parseNumber(context, reader, Byte::parseByte), (context, builder, value) -> builder.append(value), BASE_10_COMPLETER_FUNC);
    public static final ParameterType<Short> SHORT = SystemParameterType.of(Short.class, "system:short", (context, reader) -> SystemParameterType.isDigit(reader.current(), 10), (context, reader) -> SystemParameterType.parseNumber(context, reader, Short::parseShort), (context, builder, value) -> builder.append(value), BASE_10_COMPLETER_FUNC);
    public static final ParameterType<Integer> INT = SystemParameterType.of(Integer.class, "system:int", (context, reader) -> SystemParameterType.isDigit(reader.current(), 10), (context, reader) -> SystemParameterType.parseNumber(context, reader, Integer::parseInt), (context, builder, value) -> builder.append(value), BASE_10_COMPLETER_FUNC);
    public static final ParameterType<Long> LONG = SystemParameterType.of(Long.class, "system:long", (context, reader) -> SystemParameterType.isDigit(reader.current(), 10), (context, reader) -> SystemParameterType.parseNumber(context, reader, Long::parseLong), (context, builder, value) -> builder.append(value), BASE_10_COMPLETER_FUNC);
    public static final ParameterType<Float> FLOAT = SystemParameterType.of(Float.class, "system:float", (context, reader) -> SystemParameterType.isDigit(reader.current(), 10), (context, reader) -> SystemParameterType.parseNumberFloat(context, reader, Float::parseFloat), (context, builder, value) -> builder.append(value), BASE_10_F_COMPLETER_FUNC);
    public static final ParameterType<Double> DOUBLE = SystemParameterType.of(Double.class, "system:double", (context, reader) -> SystemParameterType.isDigit(reader.current(), 10), (context, reader) -> SystemParameterType.parseNumberFloat(context, reader, Double::parseDouble), (context, builder, value) -> builder.append(value), BASE_10_F_COMPLETER_FUNC);
    public static final ParameterType<String> STRING = SystemParameterType.of(String.class, "system:string", (context, reader) -> true, (context, reader) -> {
        if (reader.current() == '\"') {
            reader.next();
            return reader.collect(c -> c.charValue() != '\"', 1);
        }
        return reader.collect(c -> c.charValue() != ' ');
    }, (context, builder, s) -> builder.append("\"").append((String)s).append("\""), (ctx, reader, acc) -> {
        if (reader.current() == '\"') {
            for (char i = '\u0000'; i < 'd'; i = (char)(i + '\u0001')) {
                acc.suggest(Character.valueOf(i));
            }
            reader.next();
            reader.collect(c -> c.charValue() != '\"', 1);
            return;
        }
        reader.collect(c -> c.charValue() != ' ');
    });
    public static final ParameterType<Character> CHAR = SystemParameterType.of(Character.class, "system:char", (context, reader) -> true, (context, reader) -> {
        if (reader.current() == '\'') {
            reader.next();
            return Character.valueOf(reader.collect(c -> c.charValue() != '\'', 1).charAt(0));
        }
        return Character.valueOf(reader.collect(c -> c.charValue() != ' ').charAt(0));
    }, (context, builder, s) -> builder.append("'").append(s).append("'"), new Object[0]);
    public static final ParameterType<Identifier> IDENTIFIER = SystemParameterType.of(Identifier.class, "system:identifier", (context, stringReader) -> true, (context, reader) -> Identifier.of(STRING.parse((Context)context, (StringReader)reader)), (context, builder, s) -> builder.append(s.toString()), (context, suggestions) -> context.getLocalOption(KEY_PROVIDER_OPTION).ifPresent(p -> p.provideKeys(suggestions::suggest)));
    public static final ParameterType<Path> FILE_PATH = SystemParameterType.of(Path.class, "system:filepath", (context, reader) -> true, (context, reader) -> Path.of(STRING.parse((Context)context, (StringReader)reader), new String[0]), (context, builder, v) -> builder.append("\"").append(v.toString()).append("\n"), new Object[0]);
    public static final GenericParameterType<List> LIST = SystemParameterType.ofGeneric(List.class, "system:list", "T", (context, reader, types) -> true, (context, reader, types) -> {
        char c1;
        ParameterType type = (ParameterType)types.get("T");
        ArrayList list = new ArrayList();
        while ((c1 = reader.next()) != ']' && c1 != '\uffff') {
            reader.collect(c -> c.charValue() == ' ');
            list.add(type.parse((Context)context, (StringReader)reader));
        }
        return list;
    }, (context, builder, v, types) -> {
        ParameterType type = (ParameterType)types.get("T");
        builder.append("[");
        int l = v.size();
        for (int i = 0; i < l; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            type.write((Context)context, (StringBuilder)builder, v.get(i));
        }
        builder.append("]");
    }, (context, reader, suggestions, types) -> {
        suggestions.suggest("]");
        suggestions.suggest(",");
        ((ParameterType)types.get("T")).suggest(context, suggestions);
        reader.collect(c -> c.charValue() != ']', 1);
    });
    public static final ParameterType<Vector> VECTOR_3F = SystemParameterType.of(Vector.class, "system:vec3f", (context, reader) -> reader.current() == '(' || SystemParameterType.isDigit(reader.current(), 10), (context, reader) -> {
        boolean bracketed = false;
        if (reader.current() == '(') {
            bracketed = true;
            reader.next();
        }
        double[] c = new double[3];
        for (int i = 0; i < 3; ++i) {
            c[i] = DOUBLE.parse((Context)context, (StringReader)reader);
            if (!bracketed) {
                reader.collect(c1 -> c1.charValue() != ' ', 1);
                continue;
            }
            reader.collect(c1 -> c1.charValue() != ',' && c1.charValue() != ')', 1);
        }
        return new Vector(c[0], c[1], c[2]);
    }, (context, builder, vector) -> builder.append("(").append(vector.getX()).append(", ").append(vector.getY()).append(", ").append(vector.getZ()).append(")"), (context, reader, acc) -> {
        boolean bracketed = false;
        if (reader.current() == '(') {
            bracketed = true;
            reader.next();
        }
        for (int i = 0; i < 3; ++i) {
            DOUBLE.parse(context, reader);
            if (!bracketed) {
                reader.collect(c1 -> c1.charValue() != ' ', 1);
                continue;
            }
            reader.collect(c1 -> c1.charValue() != ',' && c1.charValue() != ')', 1);
        }
    });
    public static final ParameterType<TypeIdentifier> TYPE_IDENTIFIER = SystemParameterType.of(TypeIdentifier.class, "system:type_identifier", (context, reader) -> true, (context, reader) -> TypeIdentifier.of(reader.collect(c -> c.charValue() != ' ')), (context, builder, identifier) -> builder.append(identifier), new Object[0]);
    public static final ParameterType<ParameterType> TYPE = SystemParameterType.of(ParameterType.class, "system:type", (context, reader) -> true, (context, reader) -> context.engine().getTypeResolver().compile(TYPE_IDENTIFIER.parse((Context)context, (StringReader)reader)), (context, builder, o) -> builder.append(o.getIdentifier()), new Object[0]);
    public static final ParameterType<UUID> UUID = SystemParameterType.of(UUID.class, "system:uuid", (context, reader) -> true, (context, reader) -> java.util.UUID.fromString(reader.collect(c -> c.charValue() != ' ')), (context, builder, uuid) -> builder.append(uuid), new Object[0]);
    public static final ParameterType<Class> CLASS = SystemParameterType.of(Class.class, "system:class", (context, reader) -> true, (context, reader) -> {
        String n = reader.collect(c -> c.charValue() != ' ');
        try {
            return Class.forName(n);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }, (context, builder, aClass) -> builder.append(aClass.getName()), new Object[0]);

    private SystemParameterType() {
    }

    static <T> ParameterType<T> of(final Class<T> klass, String baseId, final BiPredicate<Context, StringReader> acceptor, final BiFunction<Context, StringReader, T> parser, final TriConsumer<Context, StringBuilder, T> writer, Object ... optional) {
        final TypeIdentifier bid = TypeIdentifier.of(baseId);
        CompleterFunc completerFunc = null;
        for (Object o : optional) {
            if (!(o instanceof CompleterFunc)) continue;
            completerFunc = (CompleterFunc)o;
        }
        final CompleterFunc finalCompleterFunc = completerFunc;
        ParameterType type = new ParameterType<T>(){

            @Override
            public TypeIdentifier getBaseIdentifier() {
                return bid;
            }

            @Override
            public Class<T> getType() {
                return klass;
            }

            @Override
            public boolean accepts(Context context, StringReader reader) {
                return acceptor.test(context, reader);
            }

            @Override
            public T parse(Context context, StringReader reader) {
                return parser.apply(context, reader);
            }

            @Override
            public void write(Context context, StringBuilder builder, T v) {
                writer.accept(context, builder, v);
            }

            @Override
            public void suggest(Context context, SuggestionAccumulator suggestions) {
                if (finalCompleterFunc != null) {
                    finalCompleterFunc.doSuggestions(context, context.reader().branch(), suggestions);
                }
            }

            public String toString() {
                return bid.toString();
            }
        };
        SystemParameterType.typeResolver.types.put(bid.getPath(), type);
        return type;
    }

    static <T> GenericParameterType<T> ofGeneric(final Class<T> klass, String baseId, String paramsStr, final TriPredicate<Context, StringReader, LinkedHashMap<String, ParameterType>> acceptor, final TriFunction<Context, StringReader, LinkedHashMap<String, ParameterType>, T> parser, final QuadConsumer<Context, StringBuilder, T, LinkedHashMap<String, ParameterType>> writer, Object ... optional) {
        final TypeIdentifier bid = TypeIdentifier.of(baseId);
        String[] params = paramsStr.split(" ");
        GenericCompleterFunc suggester = null;
        for (Object o : optional) {
            if (!(o instanceof GenericCompleterFunc)) continue;
            suggester = (GenericCompleterFunc)o;
        }
        final GenericCompleterFunc finalSuggester = suggester;
        GenericParameterType type = new GenericParameterType<T>(params){

            @Override
            public boolean accepts(Context context, StringReader reader, LinkedHashMap<String, ParameterType> types) {
                return acceptor.test(context, reader, types);
            }

            @Override
            public T parse(Context context, StringReader reader, LinkedHashMap<String, ParameterType> types) {
                return parser.apply(context, reader, types);
            }

            @Override
            public void write(Context context, StringBuilder builder, T v, LinkedHashMap<String, ParameterType> types) {
                writer.accept(context, builder, v, types);
            }

            @Override
            public void suggest(Context context, SuggestionAccumulator suggestions, LinkedHashMap<String, ParameterType> types) {
                if (finalSuggester != null) {
                    finalSuggester.doSuggestions(context, context.reader().branch(), suggestions, types);
                } else {
                    try {
                        this.parse(context, context.reader());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public TypeIdentifier getBaseIdentifier() {
                return bid;
            }

            @Override
            public Class<?> getType() {
                return klass;
            }
        };
        SystemParameterType.typeResolver.types.put(bid.getPath(), type);
        return type;
    }

    private static boolean isDigit(char c, int radix) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '_';
    }

    private static <T extends Number> T parseNumberFloat(Context context, StringReader reader, Function<String, T> parser) {
        return (T)SystemParameterType.parseNumber(context, reader, (str, __) -> (Number)parser.apply((String)str));
    }

    private static <T extends Number> T parseNumber(Context context, StringReader reader, BiFunction<String, Integer, T> parser) {
        reader.collect(c -> c.charValue() == ' ');
        int idx = reader.index();
        int radix = 10;
        if (reader.current() == '0') {
            boolean c2 = true;
            switch (reader.peek(1)) {
                case 'x': {
                    radix = 16;
                    break;
                }
                case 'b': {
                    radix = 2;
                    break;
                }
                case 'o': {
                    radix = 8;
                    break;
                }
                default: {
                    c2 = false;
                }
            }
            if (c2) {
                reader.next(2);
            }
        }
        int rdx = radix;
        String str = reader.collect(c -> SystemParameterType.isDigit(c.charValue(), rdx), c -> c.charValue() == '_');
        try {
            return (T)((Number)parser.apply(str, radix));
        }
        catch (NumberFormatException e) {
            throw new NodeParseException(context.rootCommand(), context.currentNode(), new ErrorLocation(reader, idx, reader.index()), "NaN (radix " + radix + "): '" + str + "'");
        }
    }

    static interface CompleterFunc {
        public void doSuggestions(Context var1, StringReader var2, SuggestionAccumulator var3);
    }

    public static final class SystemTypeResolver
    implements TypeResolver {
        protected HashMap<String, ParameterType<?>> types = new HashMap();

        @Override
        public ParameterType<?> resolve(Identifier identifier) {
            return this.types.get(identifier.getPath());
        }
    }

    static interface GenericCompleterFunc {
        public void doSuggestions(Context var1, StringReader var2, SuggestionAccumulator var3, LinkedHashMap<String, ParameterType> var4);
    }
}

