/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.impl;

import java.util.ArrayList;
import java.util.List;
import net.orbyfied.j8.command.CommandEngine;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.component.Properties;
import net.orbyfied.j8.command.impl.DelegatingNamespacedTypeResolver;
import net.orbyfied.j8.command.minecraft.MinecraftParameterType;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BukkitCommandEngine
extends CommandEngine {
    private static final SimpleCommandMap commandMap = (SimpleCommandMap)Bukkit.getCommandMap();
    private final Plugin plugin;

    public BukkitCommandEngine(Plugin plugin) {
        this.plugin = plugin;
        ((DelegatingNamespacedTypeResolver)this.getTypeResolver()).namespace("minecraft", MinecraftParameterType.typeResolver);
    }

    @Override
    protected void registerPlatform(Node root) {
        RegisteredBukkitCommand cmd = new RegisteredBukkitCommand(this, root);
        commandMap.register(cmd.getLabel(), (Command)cmd);
    }

    @Override
    protected void unregisterPlatform(Node root) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void enablePlatform() {
    }

    @Override
    public void disablePlatform() {
    }

    private static String stitchArgs(String label, String[] args) {
        StringBuilder b = new StringBuilder(label);
        for (String s : args) {
            b.append(" ").append(s);
        }
        return b.toString();
    }

    private static SuggestionAccumulator createSuggestionAccumulator(final List<String> list) {
        return new SuggestionAccumulator(){

            @Override
            public void suggest0(String s) {
                list.add(s);
            }

            @Override
            public void unsuggest0(String o) {
                if (o != null) {
                    list.remove(o);
                }
            }
        };
    }

    static class RegisteredBukkitCommand
    extends BukkitCommand {
        protected final CommandEngine engine;
        protected final Node node;

        protected RegisteredBukkitCommand(CommandEngine engine, Node node) {
            super(node.getName(), "", "", node.getAliases());
            this.engine = engine;
            this.node = node;
            Properties rcp = node.getComponentOf(Properties.class);
            if (rcp != null) {
                if (rcp.description() != null) {
                    this.setDescription(rcp.description());
                }
                if (rcp.label() != null) {
                    this.setLabel(rcp.label());
                }
                if (rcp.usage() != null) {
                    this.setUsage(rcp.usage());
                }
            }
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
            String str = BukkitCommandEngine.stitchArgs(alias, args);
            Context ctx = this.engine.dispatch(sender, str, null, null);
            if (ctx.intermediateText() != null && !ctx.intermediateText().isBlank()) {
                sender.sendMessage(ctx.intermediateText());
            }
            return ctx.successful();
        }

        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args, Location location) throws IllegalArgumentException {
            ArrayList<String> list = new ArrayList<String>();
            String str = BukkitCommandEngine.stitchArgs(alias, args);
            Context ctx = this.engine.dispatch(sender, str, BukkitCommandEngine.createSuggestionAccumulator(list), null);
            return list;
        }
    }
}

