/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.exception;

import net.md_5.bungee.api.ChatColor;
import net.orbyfied.j8.command.ErrorLocation;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.exception.CommandException;

public class CommandParseException
extends CommandException {
    protected ErrorLocation location;

    public CommandParseException(Node rootCommand, ErrorLocation loc, String message) {
        super(rootCommand, message);
        this.location = loc;
    }

    public CommandParseException(Node rootCommand, ErrorLocation loc, Exception e) {
        super(rootCommand, (Throwable)e);
        this.location = loc;
    }

    public CommandParseException(Node rootCommand, ErrorLocation loc, String msg, Exception e) {
        super(rootCommand, msg, e);
        this.location = loc;
    }

    @Override
    public boolean isSevere() {
        return false;
    }

    public ErrorLocation getLocation() {
        return this.location;
    }

    @Override
    public String getErrorName() {
        return "Command Parsing";
    }

    @Override
    public String getFormattedString() {
        return super.getFormattedPrefix() + ChatColor.WHITE + " at " + CommandParseException.getLocationString(this.location) + this.getFormattedSuffix();
    }

    public static String getLocationString(ErrorLocation loc) {
        StringBuilder b = new StringBuilder();
        b.append(ChatColor.GREEN).append("...");
        b.append(ChatColor.GRAY).append("[").append(loc.getStartIndex()).append(":").append(loc.getEndIndex()).append("]").append(" ");
        String str = loc.getReader().getString();
        String subPrefix = str.substring(Math.max(0, loc.getStartIndex() - 6), loc.getStartIndex());
        String sub = str.substring(loc.getStartIndex(), loc.getEndIndex());
        String subSuffix = str.substring(Math.min(str.length() - 1, loc.getEndIndex()), Math.min(str.length() - 1, loc.getEndIndex() + 6));
        b.append(ChatColor.GREEN).append(subPrefix);
        b.append(ChatColor.RED).append(ChatColor.UNDERLINE).append(sub);
        b.append(ChatColor.GREEN).append(subSuffix);
        b.append(ChatColor.GREEN).append("...");
        return b.toString();
    }
}

