/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.component;

import java.util.Set;
import net.orbyfied.j8.command.AbstractNodeComponent;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.component.Completable;
import net.orbyfied.j8.command.component.Functional;
import net.orbyfied.j8.command.component.Selecting;
import net.orbyfied.j8.command.impl.CommandNodeExecutor;
import net.orbyfied.j8.util.StringReader;

public class Executable
extends AbstractNodeComponent
implements Selecting,
Functional,
Completable {
    private CommandNodeExecutor walkExecutor;
    private CommandNodeExecutor executor;
    private Set<String> aliases;

    public Executable(Node node) {
        super(node);
        this.aliases = Set.of(this.node.getAliases().toArray(new String[0]));
    }

    public Executable setWalkExecutor(CommandNodeExecutor e) {
        this.walkExecutor = e;
        return this;
    }

    public Executable setExecutor(CommandNodeExecutor e) {
        this.executor = e;
        return this;
    }

    @Override
    public boolean selects(Context ctx, StringReader reader) {
        String s = reader.collect(c -> c.charValue() != ' ');
        if (s.equals(this.node.getName())) {
            return true;
        }
        return this.aliases.contains(s);
    }

    @Override
    public void walked(Context ctx, StringReader reader) {
        reader.collect(c -> c.charValue() != ' ');
        if (this.walkExecutor != null) {
            this.walkExecutor.execute(ctx, this.node);
        }
    }

    @Override
    public void execute(Context ctx) {
        if (this.executor != null) {
            this.executor.execute(ctx, this.node);
        }
    }

    @Override
    public void completeSelf(Context context, Node from, SuggestionAccumulator suggestions) {
        suggestions.suggest(this.node.getName());
    }
}

