/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.md_5.bungee.api.ChatColor;
import net.orbyfied.j8.command.CommandEngine;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.component.Executable;
import net.orbyfied.j8.command.exception.CommandHaltException;
import net.orbyfied.j8.command.parameter.Flag;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.StringReader;
import org.bukkit.command.CommandSender;

public class Context {
    protected final CommandSender sender;
    protected Destiny destiny;
    protected Node rootCommand;
    protected final HashMap<Identifier, Object> symbols = new HashMap();
    protected final HashMap<Identifier, Object> options = new HashMap();
    protected final CommandEngine engine;
    protected String intermediateText;
    protected boolean canFormat = true;
    protected Boolean successful;
    protected StringReader reader;
    protected Node current;
    protected Executable currentExecutable;
    protected List<Flag<?>> flags = new ArrayList();
    protected Map<String, Flag<?>> flagsByName = new HashMap();
    protected Map<Character, Flag<?>> flagsByChar = new HashMap();
    protected Map<Flag<?>, Object> flagValues = new HashMap();

    public Context(CommandEngine engine, CommandSender sender) {
        this.engine = engine;
        this.sender = sender;
    }

    public Context canFormat(boolean canFormat) {
        this.canFormat = canFormat;
        return this;
    }

    public CommandEngine engine() {
        return this.engine;
    }

    public CommandSender sender() {
        return this.sender;
    }

    public Destiny destiny() {
        return this.destiny;
    }

    public String intermediateText() {
        return this.intermediateText;
    }

    public Context intermediateText(String text) {
        if (!this.canFormat) {
            text = ChatColor.stripColor((String)text);
        }
        this.intermediateText = text;
        return this;
    }

    public Context successful(boolean b) {
        this.successful = b;
        return this;
    }

    public Boolean successful() {
        return this.successful;
    }

    public Context destiny(Destiny destiny) {
        this.destiny = destiny;
        return this;
    }

    public Node rootCommand() {
        return this.rootCommand;
    }

    public StringReader reader() {
        return this.reader;
    }

    public Executable currentExecutable() {
        return this.currentExecutable;
    }

    public Node currentNode() {
        return this.current;
    }

    public Context halt(boolean success, String message) {
        throw new CommandHaltException(this.rootCommand, message).setSuccessful(success);
    }

    public Context halt(boolean success, Throwable t) {
        throw new CommandHaltException(this.rootCommand, t).setSuccessful(success);
    }

    public Context halt(boolean success, String message, Throwable t) {
        throw new CommandHaltException(this.rootCommand, message, t).setSuccessful(success);
    }

    public Context fail(String message) {
        return this.halt(false, message);
    }

    public Context fail(Throwable t) {
        return this.halt(false, t);
    }

    public Context fail(String message, Throwable t) {
        return this.halt(false, message, t);
    }

    public HashMap<Identifier, Object> getSymbols() {
        return this.symbols;
    }

    public <T> T getSymbol(Identifier identifier) {
        return (T)this.symbols.get(identifier);
    }

    public <T> T getSymbol(String id) {
        return this.getSymbol(Identifier.of((String)id));
    }

    public <T> T getSymbol(Identifier identifier, Class<T> tClass) {
        return (T)this.symbols.get(identifier);
    }

    public <T> T getSymbol(String id, Class<T> tClass) {
        return this.getSymbol(Identifier.of((String)id), tClass);
    }

    public Context setSymbol(Identifier id, Object o) {
        this.symbols.put(id, o);
        return this;
    }

    public Context setSymbol(String id, Object o) {
        return this.setOption(Identifier.of((String)id), o);
    }

    public Context unsetSymbol(Identifier id) {
        this.symbols.remove(id);
        return this;
    }

    public Context unsetSymbol(String id) {
        return this.unsetSymbol(Identifier.of((String)id));
    }

    public HashMap<Identifier, Object> getOptions() {
        return this.symbols;
    }

    public <T> Optional<T> getLocalOption(String identifier, Class<T> tClass) {
        return this.getOption(new Identifier(this.current.name, identifier));
    }

    public <T> Optional<T> getLocalOption(String identifier) {
        return this.getOption(new Identifier(this.current.name, identifier));
    }

    public Context setLocalOption(String identifier, Object o) {
        return this.setOption(new Identifier(this.current.name, identifier), o);
    }

    public Context unsetLocalOption(String identifier) {
        return this.unsetOption(new Identifier(this.current.name, identifier));
    }

    public <T> Optional<T> getOption(Identifier identifier) {
        return Optional.ofNullable(this.options.get(identifier));
    }

    public <T> Optional<T> getOption(String identifier) {
        return this.getOption(Identifier.of((String)identifier));
    }

    public Context setOption(Identifier identifier, Object o) {
        this.options.put(identifier, o);
        return this;
    }

    public Context setOption(String id, Object o) {
        return this.setOption(Identifier.of((String)id), o);
    }

    public Context unsetOption(Identifier id) {
        this.options.remove(id);
        return this;
    }

    public Context unsetOption(String id) {
        this.options.remove(Identifier.of((String)id));
        return this;
    }

    public Context pushFlag(Flag<?> flag) {
        this.flags.add(flag);
        this.flagsByName.put(flag.getName(), flag);
        Character c = flag.getCharacter();
        if (c != null) {
            this.flagsByChar.put(c, flag);
        }
        return this;
    }

    public List<Flag<?>> getFlags() {
        return this.flags;
    }

    public Flag<?> getFlagByName(String name) {
        return this.flagsByName.get(name);
    }

    public Flag<?> getFlagByCharacter(char c) {
        return this.flagsByChar.get(Character.valueOf(c));
    }

    public <T> T getFlagValue(Flag<T> flag) {
        if (flag == null) {
            return null;
        }
        Object res = !this.flagValues.containsKey(flag) ? flag.getDefault() : this.flagValues.get(flag);
        return res;
    }

    public <T> T getFlagValue(String name) {
        return (T)this.getFlagValue(this.flagsByName.get(name));
    }

    public <T> T getFlagValue(String name, Class<T> tClass) {
        return (T)this.flagValues.get(this.flagsByName.get(name));
    }

    public <T> T getFlagValue(Flag<?> flag, T ifUnset) {
        if (flag == null) {
            return ifUnset;
        }
        if (!this.flagValues.containsKey(flag)) {
            return ifUnset;
        }
        return (T)this.getFlagValue(flag);
    }

    public <T> T getFlagValue(Flag<?> flag, Class<T> tClass, T ifUnset) {
        if (flag == null) {
            return ifUnset;
        }
        if (!this.flagValues.containsKey(flag)) {
            return ifUnset;
        }
        return (T)this.getFlagValue(flag);
    }

    public <T> T getFlagValue(String name, Class<T> tClass, T ifUnset) {
        Flag<?> flag = this.flagsByName.get(name);
        if (flag == null) {
            return ifUnset;
        }
        if (!this.flagValues.containsKey(flag)) {
            return ifUnset;
        }
        return (T)this.getFlagValue(flag);
    }

    public static enum Destiny {
        SUGGEST,
        EXECUTE;

    }
}

