/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.parameter.GenericTypeInstance;
import net.orbyfied.j8.command.parameter.ParameterType;
import net.orbyfied.j8.command.parameter.TypeIdentifier;
import net.orbyfied.j8.util.StringReader;

public abstract class GenericParameterType<B>
implements ParameterType<B> {
    final ArrayList<String> parameters;

    public GenericParameterType(List<String> params) {
        this.parameters = new ArrayList<String>(params);
    }

    public GenericParameterType(String ... params) {
        this(Arrays.asList(params));
    }

    public Class<B> getBaseType() {
        return this.getType();
    }

    public TypeIdentifier getGenericIdentifier(LinkedHashMap<String, ParameterType<?>> typeParams) {
        TypeIdentifier id = this.getBaseIdentifier().clone();
        for (ParameterType<?> pt : typeParams.values()) {
            id.getTypeParams().add(pt.getIdentifier());
        }
        return id;
    }

    public List<String> getTypeParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String getTypeParameter(int i) {
        return this.parameters.get(i);
    }

    @Override
    public TypeIdentifier getIdentifier() {
        return this.getBaseIdentifier();
    }

    @Override
    public boolean accepts(Context context, StringReader reader) {
        throw new IllegalArgumentException("Raw use of parameterized type " + this.getBaseIdentifier());
    }

    @Override
    public B parse(Context context, StringReader reader) {
        throw new IllegalArgumentException("Raw use of parameterized type " + this.getBaseIdentifier());
    }

    @Override
    public void write(Context context, StringBuilder builder, B v) {
        throw new IllegalArgumentException("Raw use of parameterized type " + this.getBaseIdentifier());
    }

    @Override
    public void suggest(Context context, SuggestionAccumulator suggestions) {
        throw new IllegalArgumentException("Raw use of parameterized type " + this.getBaseIdentifier());
    }

    public GenericTypeInstance<B> instance(ParameterType ... types) {
        return new GenericTypeInstance(this, types);
    }

    public GenericTypeInstance<B> instance(List<ParameterType> types) {
        return new GenericTypeInstance(this, types);
    }

    public abstract boolean accepts(Context var1, StringReader var2, LinkedHashMap<String, ParameterType> var3);

    public abstract B parse(Context var1, StringReader var2, LinkedHashMap<String, ParameterType> var3);

    public abstract void write(Context var1, StringBuilder var2, B var3, LinkedHashMap<String, ParameterType> var4);

    public abstract void suggest(Context var1, SuggestionAccumulator var2, LinkedHashMap<String, ParameterType> var3);
}

