/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.exception;

import net.md_5.bungee.api.ChatColor;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.exception.Warning;

public class CommandException
extends RuntimeException {
    protected final Node rootCommand;

    public CommandException(Node rootCommand, String message) {
        super(message);
        this.rootCommand = rootCommand;
    }

    public CommandException(Node rootCommand, Throwable e) {
        super(e);
        this.rootCommand = rootCommand;
    }

    public CommandException(Node rootCommand, String msg, Throwable e) {
        super(msg, e);
        this.rootCommand = rootCommand;
    }

    public boolean isSevere() {
        return true;
    }

    public Node getRootCommand() {
        return this.rootCommand;
    }

    public String getErrorName() {
        return this.getClass().getSimpleName();
    }

    public String getFormattedPrefix() {
        boolean isWarning = this instanceof Warning;
        ChatColor c = ChatColor.RED;
        if (isWarning) {
            c = ChatColor.GOLD;
        }
        return c + (String)(isWarning ? "\u26a0" : ChatColor.BOLD + "\u00d7") + " " + c + this.getErrorName() + (String)(this.getCause() != null ? " (" + this.getCause().getClass().getSimpleName() + ")" : "") + ChatColor.DARK_GRAY + " in command(" + this.rootCommand.getName() + ")";
    }

    public String getFormattedSuffix() {
        return ChatColor.YELLOW + (String)(this.getMessage() != null ? ": " + this.getMessage() : "") + (String)(this.getCause() != null ? ": " + this.getCause().getMessage() : "");
    }

    public String getFormattedString() {
        return this.getFormattedPrefix() + this.getFormattedSuffix();
    }
}

