/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.annotation;

import net.orbyfied.j8.command.CommandEngine;
import net.orbyfied.j8.command.Flags;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.Selecting;
import net.orbyfied.j8.command.annotation.AnnotationProcessingException;
import net.orbyfied.j8.command.annotation.BaseAnnotationProcessor;
import net.orbyfied.j8.command.parameter.Flag;
import net.orbyfied.j8.command.parameter.Parameter;
import net.orbyfied.j8.command.parameter.ParameterType;
import net.orbyfied.j8.command.parameter.TypeIdentifier;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.StringReader;

public class SubcommandParser {
    protected final CommandEngine engine;
    protected final Node root;
    protected final String raw;
    protected final BaseAnnotationProcessor bap;

    public SubcommandParser(BaseAnnotationProcessor bap, CommandEngine engine, Node root, String raw) {
        this.bap = bap;
        this.engine = engine;
        this.root = root;
        this.raw = raw;
    }

    public CommandEngine getEngine() {
        return this.engine;
    }

    public Node getRoot() {
        return this.root;
    }

    public String getRaw() {
        return this.raw;
    }

    public Node parse() {
        StringReader reader = new StringReader(this.raw, 0);
        Node current = this.root;
        Node last = this.root;
        while (reader.current() != '\uffff') {
            String name;
            Object type;
            char c1 = reader.current();
            if (c1 != '[' && c1 != '<' && c1 != '(') {
                String component = reader.collect(c -> c.charValue() != ' ', 1);
                last = current = current.getOrCreateSubnode(component, parent -> new Node(component, (Node)parent, parent.root()).makeExecutable(null));
                continue;
            }
            if (c1 == '(') {
                reader.next();
                if (reader.current() == '\uffff') {
                    throw new AnnotationProcessingException("Unexpected EOF while parsing flag @ idx: " + reader.index());
                }
                TypeIdentifier tid = TypeIdentifier.of(reader.collect(c2 -> c2.charValue() != ' '));
                type = this.engine.getTypeResolver().compile(tid);
                if (reader.current() != ' ') {
                    throw new AnnotationProcessingException("Expected ' ' to continue to type declaration @ idx: " + reader.index());
                }
                reader.next();
                name = reader.collect(c -> c.charValue() != '/' && c.charValue() != ' ' && c.charValue() != ')');
                Character c3 = null;
                if (reader.current() == '/') {
                    c3 = Character.valueOf(reader.next());
                    reader.next();
                }
                boolean isSwitch = false;
                if (reader.current() == ' ' && reader.next() == '/') {
                    isSwitch = true;
                    reader.next();
                }
                if (reader.current() != ')') {
                    throw new AnnotationProcessingException("Expected ')' to close type and flag declaration @ idx: " + reader.index());
                }
                Flags flags = last.component(Flags.class, Flags::new);
                Flag flag = new Flag(flags, name, c3, type, isSwitch);
                flags.addFlag(flag);
                reader.next();
                continue;
            }
            boolean isReq = reader.current() == '<';
            reader.next();
            if (reader.current() == '\uffff') {
                throw new AnnotationProcessingException("Unexpected EOF while parsing parameter @ idx: " + reader.index());
            }
            type = reader.collect(c -> c.charValue() != ' ', 1);
            name = reader.collect(c -> c.charValue() != '>' && c.charValue() != ']', 1);
            Node paramNode = current.getSubnode(name);
            if (paramNode == null) {
                TypeIdentifier tid = TypeIdentifier.of((String)type);
                ParameterType<?> pt = this.engine.getTypeResolver().compile(tid);
                Identifier pid = new Identifier(null, name);
                paramNode = current.getOrCreateSubnode(name, parent -> new Node(name, (Node)parent, parent.root()).makeParameter(pt).getComponent(Parameter.class).setIdentifier(pid).getNode());
            }
            reader.next();
            current = paramNode;
        }
        if (current.getComponentOf(Selecting.class) == null) {
            current.makeExecutable(null);
        }
        if (last.getComponentOf(Selecting.class) == null) {
            last.makeExecutable(null);
        }
        return last;
    }
}

