/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.ErrorLocation;
import net.orbyfied.j8.command.Executable;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.Selecting;
import net.orbyfied.j8.command.Suggester;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.exception.CommandException;
import net.orbyfied.j8.command.exception.CommandParseException;
import net.orbyfied.j8.command.exception.NodeExecutionException;
import net.orbyfied.j8.command.exception.NodeParseException;
import net.orbyfied.j8.command.impl.DelegatingNamespacedTypeResolver;
import net.orbyfied.j8.command.impl.SystemParameterType;
import net.orbyfied.j8.command.parameter.Flag;
import net.orbyfied.j8.command.parameter.Parameter;
import net.orbyfied.j8.command.parameter.TypeResolver;
import net.orbyfied.j8.util.StringReader;
import org.bukkit.command.CommandSender;

public abstract class CommandEngine {
    TypeResolver typeResolver;
    ArrayList<Node> commands = new ArrayList();
    HashMap<String, Node> aliases = new HashMap();

    public CommandEngine() {
        this.typeResolver = new DelegatingNamespacedTypeResolver().namespace("system", SystemParameterType.typeResolver);
    }

    public CommandEngine register(Node command) {
        this.commands.add(command);
        this.aliases.put(command.getName(), command);
        for (String alias : command.aliases) {
            this.aliases.put(alias, command);
        }
        this.registerPlatform(command);
        return this;
    }

    public CommandEngine unregister(Node command) {
        this.commands.remove(command);
        this.aliases.remove(command.getName(), command);
        for (String alias : command.aliases) {
            this.aliases.remove(alias, command);
        }
        this.unregisterPlatform(command);
        return this;
    }

    public CommandEngine setTypeResolver(TypeResolver resolver) {
        this.typeResolver = resolver;
        return this;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    protected abstract void registerPlatform(Node var1);

    protected abstract void unregisterPlatform(Node var1);

    public abstract void enablePlatform();

    public abstract void disablePlatform();

    public Context dispatch(CommandSender sender, String str, SuggestionAccumulator suggestions, Consumer<Context> ctxConsumer) {
        Context context;
        block33: {
            boolean isSuggesting = suggestions != null;
            Context.Destiny destiny = isSuggesting ? Context.Destiny.SUGGEST : Context.Destiny.EXECUTE;
            StringReader reader = new StringReader(str, 0);
            context = new Context(this, sender);
            context.destiny(destiny);
            if (ctxConsumer != null) {
                ctxConsumer.accept(context);
            }
            context.successful(true);
            String alias = reader.collect(c -> c.charValue() != ' ', 0);
            Node root = this.aliases.get(alias);
            if (root == null) {
                return null;
            }
            context.rootCommand = root;
            context.reader = reader;
            try {
                Executable lastExecutable = null;
                Selecting mainc = root.getComponentOf(Selecting.class);
                Suggester suggester = null;
                Node current = root;
                while (true) {
                    Suggester tempSuggester;
                    context.current = current;
                    context.currentExecutable = lastExecutable;
                    if (mainc != null) {
                        mainc.getNode().walked(context, reader);
                    }
                    if (mainc instanceof Executable) {
                        Executable exec;
                        lastExecutable = exec = (Executable)mainc;
                        try {
                            exec.walked(context, reader);
                        }
                        catch (Exception e) {
                            if (e instanceof NodeExecutionException) {
                                NodeExecutionException nex = (NodeExecutionException)e;
                                throw nex;
                            }
                            throw new NodeExecutionException(root, current, (Throwable)e);
                        }
                    } else if (mainc instanceof Parameter) {
                        Parameter param = (Parameter)mainc;
                        param.walked(context, reader);
                    }
                    while (reader.peek(1) == '-') {
                        Flag<?> flag;
                        int sidx = reader.index();
                        if (reader.next(2) == '-') {
                            reader.next();
                            String flagName = reader.collect(c -> c.charValue() != '=' && c.charValue() != ' ');
                            flag = context.flagsByName.get(flagName);
                            if (flag == null) {
                                if (!isSuggesting) {
                                    throw new CommandParseException(root, new ErrorLocation(reader, sidx + 1, reader.index()), "Flag --" + flagName + " was not found.");
                                }
                                for (Flag flag2 : context.flags) {
                                    if (flag2.isSwitch()) {
                                        suggestions.suggest("--" + flag2.getName());
                                        continue;
                                    }
                                    suggestions.suggest("--" + flag2.getName() + "=");
                                }
                                continue;
                            }
                            if (reader.current() == '=') {
                                reader.next();
                                if (!isSuggesting) {
                                    Object val = flag.getType().parse(context, reader);
                                    context.flagValues.put(flag, val);
                                    continue;
                                }
                                flag.getType().suggest(context, suggestions);
                                continue;
                            }
                            if (!flag.isSwitch()) {
                                throw new CommandParseException(root, new ErrorLocation(reader, sidx + 1, reader.index()), "Flag --" + flagName + " is not a switch, but no value was provided.");
                            }
                            context.flagValues.put(flag, true);
                            reader.next();
                            continue;
                        }
                        if (!isSuggesting) {
                            char c2;
                            while ((c2 = reader.current()) != ' ' && c2 != '\uffff') {
                                flag = context.flagsByChar.get(Character.valueOf(c2));
                                if (flag == null) {
                                    throw new CommandParseException(root, new ErrorLocation(reader, sidx + 1, reader.index()), "Flag -" + c2 + " (switch) was not found.");
                                }
                                if (!flag.isSwitch()) {
                                    throw new CommandParseException(root, new ErrorLocation(reader, sidx + 1, reader.index()), "Flag -" + c2 + " is not a switch, but no value was provided.");
                                }
                                context.flagValues.put(flag, true);
                                reader.next();
                            }
                            continue;
                        }
                        for (Map.Entry<Character, Flag<?>> entry : context.flagsByChar.entrySet()) {
                            suggestions.suggest("-" + entry.getKey());
                        }
                    }
                    if (isSuggesting && (tempSuggester = current.getComponentOf(Suggester.class)) != null) {
                        suggester = tempSuggester;
                    }
                    reader.next();
                    int idx = reader.index();
                    char cb = reader.current();
                    mainc = current.getNextSubnode(context, reader);
                    if (mainc == null && cb != '\uffff') {
                        throw new NodeParseException(root, current, new ErrorLocation(reader, idx - 1, reader.index()), "Unknown subcommand.");
                    }
                    if (reader.current() == '\uffff' || mainc == null) break;
                    current = mainc.getNode();
                }
                current = null;
                if (isSuggesting && suggester != null) {
                    suggester.suggestNext(context, suggestions, reader, current);
                }
                if (lastExecutable == null || isSuggesting || !context.successful().booleanValue()) break block33;
                try {
                    lastExecutable.getNode().executed(context);
                    lastExecutable.execute(context);
                }
                catch (Exception e) {
                    if (e instanceof NodeExecutionException) {
                        NodeExecutionException nex = (NodeExecutionException)e;
                        throw nex;
                    }
                    throw new NodeExecutionException(root, lastExecutable.node, (Throwable)e);
                }
            }
            catch (CommandException e) {
                if (e.isSevere()) {
                    e.printStackTrace();
                }
                context.intermediateText(e.getFormattedString());
                context.successful(false);
            }
        }
        return context;
    }

    public Node command(String name) {
        Node node;
        node.root = node = new Node(name, null, null);
        this.register(node);
        return node;
    }
}

