/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.nbt;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.orbyfied.j8.util.nbt.CompoundObjectTag;

public class Nbt {
    public static <T> CompoundObjectTag<T> getOrCreateObject(CompoundTag sourceTag, String key, Supplier<Object> objectSupplier) {
        if (!sourceTag.contains(key)) {
            Object obj = objectSupplier.get();
            CompoundObjectTag<Object> tag = new CompoundObjectTag<Object>(obj);
            sourceTag.put(key, tag);
            return tag;
        }
        return Nbt.getOrLoadObject(sourceTag, key);
    }

    public static <T> CompoundObjectTag<T> getOrLoadObject(CompoundTag sourceTag, String key) {
        CompoundObjectTag<?> cot;
        Tag tag = sourceTag.get(key);
        if (tag == null) {
            return null;
        }
        if (tag instanceof CompoundObjectTag) {
            CompoundObjectTag cot2 = (CompoundObjectTag)tag;
            return cot2;
        }
        if (!(tag instanceof CompoundTag)) {
            throw new IllegalStateException("Tag '" + key + "' is not a compound tag and has to be loaded.");
        }
        CompoundTag ctag = (CompoundTag)tag;
        try {
            cot = CompoundObjectTag.loadFromCompound(ctag);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while loading object tag '" + key + "'", e);
        }
        if (cot == null) {
            return null;
        }
        sourceTag.put(key, cot);
        return cot;
    }

    public static CompoundTag getOrCreateCompound(CompoundTag sourceTag, String key) {
        if (!sourceTag.contains(key, 10)) {
            CompoundTag newTag = new CompoundTag();
            sourceTag.put(key, (Tag)newTag);
            return newTag;
        }
        return sourceTag.getCompound(key);
    }

    public static ListTag getOrCreateList(CompoundTag sourceTag, String key, int type) {
        if (!sourceTag.contains(key, 10)) {
            ListTag newTag = new ListTag();
            sourceTag.put(key, (Tag)newTag);
            return newTag;
        }
        return sourceTag.getList(key, type);
    }
}

