/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;

public class StringReader {
    public static final char DONE = '\uffff';
    private int index = 0;
    private String str;
    private int len;
    private static final Predicate<Character> ONPRED = c -> true;

    public StringReader(String str, int index) {
        this.str = str;
        this.len = str.length();
        this.index = index;
    }

    public int clamp(int index) {
        return Math.min(this.len - 1, Math.max(0, index));
    }

    public char peekAt(int i) {
        return this.str.charAt(this.clamp(i));
    }

    public char peek(int i) {
        int idx = this.index + i;
        if (idx < 0 || idx >= this.len) {
            return '\uffff';
        }
        return this.str.charAt(idx);
    }

    public char next() {
        if (++this.index >= this.len) {
            return '\uffff';
        }
        return this.str.charAt(this.index);
    }

    public char next(int a) {
        if ((this.index += a) >= this.len) {
            return '\uffff';
        }
        return this.str.charAt(this.index);
    }

    public char prev() {
        return this.str.charAt(this.clamp(--this.index));
    }

    public char prev(int a) {
        return this.str.charAt(this.clamp(this.index -= a));
    }

    public char current() {
        if (this.index < 0 || this.index >= this.len) {
            return '\uffff';
        }
        return this.str.charAt(this.index);
    }

    public String collect() {
        return this.collect(ONPRED, null);
    }

    public String collect(Predicate<Character> pred, int offEnd) {
        String str = this.collect(pred);
        this.next(offEnd);
        return str;
    }

    public String collect(Predicate<Character> pred) {
        return this.collect(pred, null);
    }

    public String collect(Predicate<Character> pred, Predicate<Character> skip, int offEnd) {
        String str = this.collect(pred, skip);
        this.next(offEnd);
        return str;
    }

    public String collect(Predicate<Character> pred, Predicate<Character> skip) {
        char c;
        if (pred == null) {
            pred = ONPRED;
        }
        StringBuilder b = new StringBuilder();
        this.prev();
        while ((c = this.next()) != '\uffff' && pred.test(Character.valueOf(c))) {
            if (skip != null && skip.test(Character.valueOf(c))) continue;
            b.append(c);
        }
        return b.toString();
    }

    public String pcollect(Predicate<Character> pred) {
        return this.pcollect(pred, null);
    }

    public String pcollect(Predicate<Character> pred, Predicate<Character> skip) {
        char c;
        if (pred == null) {
            pred = ONPRED;
        }
        StringBuilder b = new StringBuilder();
        int off = 0;
        while ((c = this.peek(off++)) != '\uffff' && pred.test(Character.valueOf(c))) {
            if (skip != null && skip.test(Character.valueOf(c))) continue;
            b.append(c);
        }
        return b.toString();
    }

    public List<String> split(char ... chars) {
        ArrayList<String> list = new ArrayList<String>(this.len / 10);
        HashSet<Character> charSet = new HashSet<Character>();
        for (char c2 : chars) {
            charSet.add(Character.valueOf(c2));
        }
        while (this.current() != '\uffff') {
            list.add(this.collect(c -> !charSet.contains(c)));
            this.next();
        }
        return list;
    }

    public int index() {
        return this.index;
    }

    public StringReader index(int i) {
        this.index = i;
        return this;
    }

    public String getString() {
        return this.str;
    }

    public StringReader subForward(int from, int len) {
        StringReader reader = new StringReader(this.str, from);
        reader.len = Math.min(from + len, this.len - from);
        return reader;
    }

    public StringReader subFrom(int from, int len) {
        StringReader reader = new StringReader(this.str, this.index + from);
        reader.len = Math.min(from + len, this.len - from - this.index);
        return reader;
    }

    public StringReader branch() {
        return new StringReader(this.str, this.index);
    }
}

