/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.parameter;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.orbyfied.j8.command.AbstractNodeComponent;
import net.orbyfied.j8.command.Completable;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.ErrorLocation;
import net.orbyfied.j8.command.Functional;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.Selecting;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.exception.NodeParseException;
import net.orbyfied.j8.command.parameter.ParameterType;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.StringReader;

public class Parameter
extends AbstractNodeComponent
implements Functional,
Selecting,
Completable {
    protected Identifier identifier;
    protected ParameterType<?> type;
    protected LinkedHashMap<String, Supplier<Object>> options = new LinkedHashMap();

    public Parameter(Node node) {
        super(node);
        Node parent = node;
        while ((parent = parent.parent()).hasComponentOf(Parameter.class)) {
        }
        this.identifier = new Identifier(parent.getName(), node.getName());
    }

    public Parameter setOption(String id, Supplier<Object> supplier) {
        this.options.put(id, supplier);
        return this;
    }

    public Parameter setOption(String id, Object supplied) {
        this.options.put(id, () -> supplied);
        return this;
    }

    public Parameter setIdentifier(Identifier id) {
        this.identifier = id;
        return this;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Parameter setType(ParameterType<?> type) {
        this.type = type;
        return this;
    }

    public ParameterType<?> getType() {
        return this.type;
    }

    private void putOptions(Context context) {
        for (Map.Entry<String, Supplier<Object>> entry : this.options.entrySet()) {
            context.setLocalOption(entry.getKey(), entry.getValue().get());
        }
    }

    private void remOptions(Context context) {
        for (String key : this.options.keySet()) {
            context.unsetLocalOption(key);
        }
    }

    @Override
    public void walked(Context ctx, StringReader reader) {
        Object v;
        int startIndex = reader.index();
        this.putOptions(ctx);
        try {
            v = this.type.parse(ctx, reader);
        }
        catch (Exception e) {
            if (e instanceof NodeParseException) {
                throw e;
            }
            int endIndex = reader.index();
            throw new NodeParseException(this.node.root(), this.node, new ErrorLocation(reader, startIndex, endIndex), e);
        }
        this.remOptions(ctx);
        ctx.setSymbol(this.identifier, v);
    }

    @Override
    public void execute(Context ctx) {
    }

    @Override
    public boolean selects(Context ctx, StringReader reader) {
        this.putOptions(ctx);
        boolean b = this.type.accepts(ctx, reader);
        this.remOptions(ctx);
        return b;
    }

    @Override
    public void completeSelf(Context context, Node from, SuggestionAccumulator suggestions) {
        this.putOptions(context);
        this.type.suggest(context, suggestions);
        this.remOptions(context);
    }
}

