/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import net.orbyfied.j8.command.CommandEngine;
import net.orbyfied.j8.command.CommandProperties;
import net.orbyfied.j8.command.Executable;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.annotation.BaseCommand;
import net.orbyfied.j8.command.annotation.CommandDescription;
import net.orbyfied.j8.command.annotation.CommandLabel;
import net.orbyfied.j8.command.annotation.CommandParameter;
import net.orbyfied.j8.command.annotation.CommandUsage;
import net.orbyfied.j8.command.annotation.SubInitializer;
import net.orbyfied.j8.command.annotation.Subcommand;
import net.orbyfied.j8.command.annotation.SubcommandParser;
import net.orbyfied.j8.command.exception.NodeExecutionException;
import net.orbyfied.j8.registry.Identifier;

public class BaseAnnotationProcessor {
    protected final CommandEngine engine;
    protected final Object obj;
    protected final Class<?> klass;
    protected Node root;

    public BaseAnnotationProcessor(CommandEngine engine, Object obj) {
        this.engine = engine;
        this.obj = obj;
        this.klass = obj.getClass();
    }

    public Object getObject() {
        return this.obj;
    }

    public CommandEngine getEngine() {
        return this.engine;
    }

    public Node getBase() {
        return this.root;
    }

    public BaseAnnotationProcessor compile() {
        BaseCommand baseCommandDesc = this.klass.getAnnotation(BaseCommand.class);
        this.root = new Node(baseCommandDesc.name(), null, null).addAliases(baseCommandDesc.aliases());
        this.parseExecutableNodeProperties(this.root, this.klass);
        for (Method m : this.klass.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Subcommand.class)) continue;
            m.setAccessible(true);
            Subcommand desc = m.getAnnotation(Subcommand.class);
            ArrayList<String> paramNames = new ArrayList<String>(m.getParameterCount());
            Parameter[] parameters = m.getParameters();
            int l = parameters.length;
            for (int i = 2; i < l; ++i) {
                Parameter param = parameters[i];
                if (!param.isAnnotationPresent(CommandParameter.class)) continue;
                String name = param.getAnnotation(CommandParameter.class).value();
                if (name.equals("")) {
                    name = param.getName();
                }
                paramNames.add(name);
            }
            Method initializerSub = null;
            try {
                initializerSub = this.klass.getDeclaredMethod(m.getName(), Node.class);
                if (initializerSub.isAnnotationPresent(SubInitializer.class)) {
                    initializerSub.setAccessible(true);
                }
            }
            catch (NoSuchMethodException param) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (String subcommandStr : desc.value()) {
                SubcommandParser parser = new SubcommandParser(this, this.engine, this.root, subcommandStr);
                Node sub = parser.parse();
                this.parseExecutableNodeProperties(sub, m);
                try {
                    if (initializerSub != null) {
                        initializerSub.invoke(this.obj, sub);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sub.getComponent(Executable.class).setExecutor((ctx, cmd) -> {
                    try {
                        ArrayList<Object> args = new ArrayList<Object>();
                        args.add(ctx);
                        args.add(cmd);
                        for (String paramn : paramNames) {
                            Identifier pid = new Identifier(null, paramn);
                            args.add(ctx.getSymbol(pid));
                        }
                        m.invoke(this.obj, args.toArray());
                    }
                    catch (Throwable e) {
                        throw new NodeExecutionException(cmd.root(), cmd, e);
                    }
                });
            }
        }
        return this;
    }

    protected BaseAnnotationProcessor parseExecutableNodeProperties(Node node, AnnotatedElement element) {
        CommandLabel commandLabel;
        CommandDescription commandDescription;
        CommandUsage commandUsage = element.getAnnotation(CommandUsage.class);
        if (commandUsage != null) {
            node.component(CommandProperties.class, CommandProperties::new, (n1, cp) -> cp.usage(commandUsage.value()));
        }
        if ((commandDescription = element.getAnnotation(CommandDescription.class)) != null) {
            node.component(CommandProperties.class, CommandProperties::new, (n1, cp) -> cp.description(commandDescription.value()));
        }
        if ((commandLabel = element.getAnnotation(CommandLabel.class)) != null) {
            node.component(CommandProperties.class, CommandProperties::new, (n1, cp) -> cp.label(commandLabel.value()));
        }
        return this;
    }

    public BaseAnnotationProcessor register() {
        if (this.root != null) {
            this.engine.register(this.root);
        }
        return this;
    }
}

