/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class StringReader {
    private static final int[] DIGIT_TABLE = new int[256];
    public static final char DONE = '\uffff';
    private int index = 0;
    private String str;
    private int len;
    private static final Predicate<Character> ALWAYS;

    public StringReader(String str, int index) {
        this.str = str;
        this.len = str.length();
        this.index = index;
    }

    public StringReader(String str) {
        this(str, 0);
    }

    public int clamp(int index) {
        return Math.min(this.len - 1, Math.max(0, index));
    }

    public char peekAt(int i) {
        return this.str.charAt(this.clamp(i));
    }

    public char peek(int i) {
        int idx = this.index + i;
        if (idx < 0 || idx >= this.len) {
            return '\uffff';
        }
        return this.str.charAt(idx);
    }

    public char next() {
        if (++this.index >= this.len || this.index < 0) {
            return '\uffff';
        }
        return this.str.charAt(this.index);
    }

    public char next(int a) {
        if ((this.index += a) >= this.len || this.index < 0) {
            return '\uffff';
        }
        return this.str.charAt(this.index);
    }

    public char prev() {
        if (--this.index >= this.len || this.index < 0) {
            return '\uffff';
        }
        return this.str.charAt(this.index);
    }

    public char prev(int a) {
        if ((this.index -= a) >= this.len || this.index < 0) {
            return '\uffff';
        }
        return this.str.charAt(this.index);
    }

    public char current() {
        if (this.index < 0 || this.index >= this.len) {
            return '\uffff';
        }
        return this.str.charAt(this.index);
    }

    public String collect() {
        return this.collect(ALWAYS, null);
    }

    public String collect(Predicate<Character> pred, int offEnd) {
        String str = this.collect(pred);
        this.next(offEnd);
        return str;
    }

    public String collect(Predicate<Character> pred) {
        return this.collect(pred, null);
    }

    public String collect(Predicate<Character> pred, Predicate<Character> skip, int offEnd) {
        String str = this.collect(pred, skip);
        this.next(offEnd);
        return str;
    }

    public String collect(Predicate<Character> pred, Predicate<Character> skip) {
        return this.collect(pred, skip, null);
    }

    public String collect(Predicate<Character> pred, Predicate<Character> skip, Consumer<Character> charEval) {
        char c;
        if (pred == null) {
            pred = ALWAYS;
        }
        StringBuilder b = new StringBuilder();
        this.prev();
        while ((c = this.next()) != '\uffff') {
            boolean sf = skip != null && skip.test(Character.valueOf(c));
            if (sf) continue;
            if (!pred.test(Character.valueOf(c))) break;
            if (charEval != null) {
                charEval.accept(Character.valueOf(c));
            }
            b.append(c);
        }
        return b.toString();
    }

    public String pcollect(Predicate<Character> pred) {
        return this.pcollect(pred, null);
    }

    public String pcollect(Predicate<Character> pred, Predicate<Character> skip) {
        char c;
        if (pred == null) {
            pred = ALWAYS;
        }
        StringBuilder b = new StringBuilder();
        int off = 0;
        while ((c = this.peek(off++)) != '\uffff' && pred.test(Character.valueOf(c))) {
            if (skip != null && skip.test(Character.valueOf(c))) continue;
            b.append(c);
        }
        return b.toString();
    }

    public List<String> split(char ... chars) {
        ArrayList<String> list = new ArrayList<String>(this.len / 10);
        HashSet<Character> charSet = new HashSet<Character>();
        for (char c2 : chars) {
            charSet.add(Character.valueOf(c2));
        }
        while (this.current() != '\uffff') {
            list.add(this.collect(c -> !charSet.contains(c)));
            this.next();
        }
        return list;
    }

    public int index() {
        return this.index;
    }

    public StringReader index(int i) {
        this.index = i;
        return this;
    }

    public String getString() {
        return this.str;
    }

    public StringReader subForward(int from, int len) {
        StringReader reader = new StringReader(this.str, from);
        reader.len = Math.min(from + len, this.len - from);
        return reader;
    }

    public StringReader subFrom(int from, int len) {
        StringReader reader = new StringReader(this.str, this.index + from);
        reader.len = Math.min(from + len, this.len - from - this.index);
        return reader;
    }

    public StringReader branch() {
        return new StringReader(this.str, this.index);
    }

    public String escapeRemaining(Predicate<Character> toEscape, Function<Character, String> escapeFunc) {
        StringBuilder b = new StringBuilder();
        char c = this.current();
        while (c != '\uffff') {
            if (toEscape.test(Character.valueOf(c))) {
                b.append(escapeFunc.apply(Character.valueOf(c)));
            } else {
                b.append(c);
            }
            c = this.next();
        }
        return b.toString();
    }

    public void debugPrint(String s, PrintStream stream) {
        stream.println("[READER:" + s + "] current: '" + this.current() + "', index: " + this.index() + ", nv10: " + StringReader.getDigit(this.current(), 10));
    }

    public void debugPrint(String s) {
        this.debugPrint(s, System.out);
    }

    public static boolean isDigit(char c, int radix) {
        return StringReader.getDigit(c, radix) != -1;
    }

    public static int getDigit(char c, int radix) {
        char c1 = Character.toLowerCase(c);
        if (c1 > '\u00ff') {
            return -1;
        }
        int nv = DIGIT_TABLE[c1];
        return nv < radix ? nv : -1;
    }

    public int collectInt(int radix) {
        char c;
        boolean neg = false;
        int r = 0;
        if (this.current() == '-') {
            neg = true;
            this.next();
        }
        while ((c = this.current()) != '\uffff') {
            if (c == '_' || c == '\'') {
                this.next();
                continue;
            }
            int nv = StringReader.getDigit(c, radix);
            if (nv == -1) break;
            r *= radix;
            r += nv;
            this.next();
        }
        return neg ? -r : r;
    }

    public int collectInt() {
        return this.collectInt(10);
    }

    public long collectLong(int radix) {
        char c;
        boolean neg = false;
        long r = 0L;
        if (this.current() == '-') {
            neg = true;
        }
        while ((c = this.current()) != '\uffff') {
            if (c == '_' || c == '\'') {
                this.next();
                continue;
            }
            int nv = StringReader.getDigit(c, radix);
            if (nv == -1) break;
            r *= (long)radix;
            r += (long)nv;
            this.next();
        }
        return neg ? -r : r;
    }

    public long collectLong() {
        return this.collectLong(10);
    }

    public float collectFloat() {
        boolean neg = false;
        if (this.current() == '-') {
            neg = true;
            this.next();
        }
        float f = this.collectInt(10);
        if (this.current() == '.') {
            char c;
            this.next();
            float r = 0.0f;
            float m = 0.1f;
            while ((c = this.current()) != '\uffff') {
                if (c == '_' || c == '\'') {
                    this.next();
                    continue;
                }
                int nv = StringReader.getDigit(c, 10);
                if (nv == -1) break;
                r += (float)nv * m;
                m = (float)((double)m * 0.1);
                this.next();
            }
            f += r;
        }
        return neg ? -f : f;
    }

    public double collectDouble() {
        boolean neg = false;
        if (this.current() == '-') {
            neg = true;
            this.next();
        }
        double f = this.collectLong(10);
        if (this.current() == '.') {
            char c;
            this.next();
            double r = 0.0;
            double m = 0.1f;
            while ((c = this.current()) != '\uffff') {
                if (c == '_' || c == '\'') {
                    this.next();
                    continue;
                }
                int nv = StringReader.getDigit(c, 10);
                if (nv == -1) break;
                r += (double)nv * m;
                m *= 0.1;
                this.next();
            }
            f += r;
        }
        return neg ? -f : f;
    }

    static {
        Arrays.fill(DIGIT_TABLE, -1);
        StringReader.DIGIT_TABLE[48] = 0;
        StringReader.DIGIT_TABLE[49] = 1;
        StringReader.DIGIT_TABLE[50] = 2;
        StringReader.DIGIT_TABLE[51] = 3;
        StringReader.DIGIT_TABLE[52] = 4;
        StringReader.DIGIT_TABLE[53] = 5;
        StringReader.DIGIT_TABLE[54] = 6;
        StringReader.DIGIT_TABLE[55] = 7;
        StringReader.DIGIT_TABLE[56] = 8;
        StringReader.DIGIT_TABLE[57] = 9;
        StringReader.DIGIT_TABLE[97] = 10;
        StringReader.DIGIT_TABLE[98] = 11;
        StringReader.DIGIT_TABLE[99] = 12;
        StringReader.DIGIT_TABLE[100] = 13;
        StringReader.DIGIT_TABLE[101] = 14;
        StringReader.DIGIT_TABLE[102] = 15;
        ALWAYS = c -> true;
    }
}

