/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.orbyfied.j8.util.logging.Event;
import net.orbyfied.j8.util.logging.EventLevel;
import net.orbyfied.j8.util.logging.EventLogHandler;
import net.orbyfied.j8.util.logging.LogRecord;
import net.orbyfied.j8.util.logging.Logger;

public class EventLog {
    private final String name;
    private final List<Event> events = new ArrayList<Event>();
    private final List<EventLogHandler> handlers = new ArrayList<EventLogHandler>();
    private final Map<String, EventLogHandler> handlerMap = new HashMap<String, EventLogHandler>();
    ThreadLocal<String> stage = new ThreadLocal();

    public EventLog(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public EventLog withHandler(EventLogHandler handler) {
        this.handlers.add(handler);
        this.handlerMap.put(handler.getName(), handler);
        return this;
    }

    public EventLogHandler getHandler(String name) {
        return this.handlerMap.get(name);
    }

    public EventLog stage(String name) {
        this.stage.set(name);
        return this;
    }

    public Event log(String id, EventLevel level, String msgFormat, Object ... msgValues) {
        return this.push(new Event(id).withLevel(level).withMessage(msgFormat, msgValues));
    }

    public Event info(String id, String msgFormat, Object ... msgValues) {
        return this.push(new Event(id).withMessage(msgFormat, msgValues).withLevel(EventLevel.INFO));
    }

    public Event warn(String id, String msgFormat, Object ... msgValues) {
        return this.push(new Event(id).withMessage(msgFormat, msgValues).withLevel(EventLevel.WARN));
    }

    public Event ok(String id, String msgFormat, Object ... msgValues) {
        return this.push(new Event(id).withMessage(msgFormat, msgValues).withLevel(EventLevel.OK));
    }

    public Event err(String id, String msgFormat, Object ... msgValues) {
        return this.push(new Event(id).withMessage(msgFormat, msgValues).withLevel(EventLevel.ERR));
    }

    public Event err(String id, Throwable t, String msgFormat, Object ... msgValues) {
        return this.push(new Event(id).withMessage(msgFormat, msgValues).withLevel(EventLevel.ERR).withError(t));
    }

    public Event newInfo(String id, String msgFormat, Object ... msgValues) {
        return new Event(id).withMessage(msgFormat, msgValues).withLevel(EventLevel.INFO).forLog(this);
    }

    public Event newWarn(String id, String msgFormat, Object ... msgValues) {
        return new Event(id).withMessage(msgFormat, msgValues).withLevel(EventLevel.WARN).forLog(this);
    }

    public Event newOk(String id, String msgFormat, Object ... msgValues) {
        return new Event(id).withMessage(msgFormat, msgValues).withLevel(EventLevel.OK).forLog(this);
    }

    public Event newErr(String id, String msgFormat, Object ... msgValues) {
        return new Event(id).withMessage(msgFormat, msgValues).withLevel(EventLevel.ERR).forLog(this);
    }

    public Event newErr(String id, Throwable t, String msgFormat, Object ... msgValues) {
        return new Event(id).withMessage(msgFormat, msgValues).withLevel(EventLevel.ERR).withError(t).forLog(this);
    }

    public Event push(Event event) {
        try {
            for (EventLogHandler handler : this.handlers) {
                if (!handler.isEnabled()) continue;
                handler.getAction().handle(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        this.events.add(event);
        return event;
    }

    public Event last() {
        return this.events.get(this.events.size() - 1);
    }

    protected static void setupLogging() {
    }

    public void logString(Event event, Logger logger) {
        if (event.getMessage() != null) {
            logger.stage(this.stage.get());
            logger.log(event.getLevel().getLogLevel(), (LogRecord record) -> record.withMisc(event.errors), event.getMessage());
        }
        for (Throwable t : event.errors) {
            t.printStackTrace();
        }
    }
}

