/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr.node;

import net.orbyfied.j8.util.math.expr.Context;
import net.orbyfied.j8.util.math.expr.ExpressionNode;
import net.orbyfied.j8.util.math.expr.ExpressionValue;
import net.orbyfied.j8.util.math.expr.Operator;
import net.orbyfied.j8.util.math.expr.error.ExprInterpreterException;

public class UnaryOpNode
extends ExpressionNode {
    ExpressionNode node;
    Operator op;

    public UnaryOpNode(Operator op, ExpressionNode node) {
        super(ExpressionNode.Type.UNARY_OP);
        this.op = op;
        this.node = node;
    }

    @Override
    public ExpressionValue<?> evaluate(Context ctx) {
        ExpressionValue<?> val = this.node.evaluate(ctx);
        if (val.isNil()) {
            throw new ExprInterpreterException("got a nil operand").located(this.getLocation());
        }
        double l = (Double)val.getValueAs();
        double o = 0.0;
        switch (this.op) {
            case MINUS: {
                o = -l;
                break;
            }
            default: {
                throw new ExprInterpreterException("operator not implemented: " + this.op.name()).located(this.getLocation());
            }
        }
        return new ExpressionValue<Double>(ExpressionValue.Type.NUMBER, o);
    }

    @Override
    protected String getDataAsString() {
        return this.op.getString() + "(" + this.node + ")";
    }
}

