/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging.io;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import net.orbyfied.j8.util.builder.BuilderTemplate;
import net.orbyfied.j8.util.builder.Constructor;
import net.orbyfied.j8.util.builder.Property;
import net.orbyfied.j8.util.logging.LogPipeline;
import net.orbyfied.j8.util.logging.LogRecord;

public class LogOutput {
    private static final BuilderTemplate<LogOutput, Builder> TEMPLATE = new BuilderTemplate(LogOutput.class).parameter("name", Property.ofString().require(true)).parameter("stream", Property.of(PrintStream.class).require(true)).parameter("formatted", Property.ofBool().require(false).defaulted(false)).constructors(Constructor.takeBuilder(LogOutput.class));
    public static final LogOutput STDOUT = ((LogOutput)LogOutput.builder("stdout").stream(System.out).formatted(true).build()).setActive(true);
    public static final LogOutput VOIDING = ((LogOutput)LogOutput.builder("voiding").stream(null).formatted(false).build()).setActive(true);
    final String name;
    OutputWorker worker;
    AtomicBoolean active = new AtomicBoolean(false);
    AtomicBoolean waiting = new AtomicBoolean(false);
    Object lock = new Object();
    Deque<LogRecord> queue;
    LogPipeline pipeline;
    PrintStream stream;
    boolean formatted = false;

    LogOutput(String name) {
        this.name = name;
        this.worker = new OutputWorker();
        this.pipeline = new LogPipeline();
    }

    LogOutput(Builder builder) {
        this.name = (String)builder.get("name");
        this.formatted = (Boolean)builder.get("formatted");
        this.stream = (PrintStream)builder.get("stream");
        this.queue = new ArrayDeque<LogRecord>();
        this.worker = new OutputWorker();
        this.pipeline = new LogPipeline();
    }

    public Builder fork(String name) {
        Builder b = new Builder(name);
        b.set("formatted", this.formatted);
        b.set("stream", this.stream);
        return b;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFormatted() {
        return this.formatted;
    }

    public PrintStream getStream() {
        return this.stream;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public LogPipeline pipeline() {
        return this.pipeline;
    }

    public void close() {
        this.setActive(false);
        this.stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(LogRecord record) {
        Object object = this.queue;
        synchronized (object) {
            this.queue.add(record);
        }
        if (this.waiting.get()) {
            object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    private void activate() {
        this.worker.start();
    }

    private void deactivate() {
        try {
            this.worker.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogOutput setActive(boolean b) {
        this.active.set(b);
        if (b) {
            this.activate();
        } else {
            this.deactivate();
        }
        return this;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    class OutputWorker
    extends Thread {
        OutputWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (LogOutput.this.active.get()) {
                try {
                    Object object = LogOutput.this.lock;
                    synchronized (object) {
                        LogOutput.this.waiting.set(true);
                        LogOutput.this.lock.wait();
                    }
                }
                catch (Exception e) {
                    LogOutput.this.waiting.set(false);
                    e.printStackTrace();
                }
                LogOutput.this.waiting.set(false);
                if (LogOutput.this.queue.size() == 0) continue;
                while (LogOutput.this.queue.size() != 0) {
                    LogRecord record = LogOutput.this.queue.poll();
                    record.setCancelled(false);
                    LogOutput.this.pipeline.push(record);
                    if (record.isCancelled()) continue;
                    String str = record.getText().toString(LogOutput.this.formatted);
                    if (LogOutput.this.stream == null) continue;
                    LogOutput.this.stream.print(str);
                }
            }
        }
    }

    public static class Builder
    extends net.orbyfied.j8.util.builder.Builder<LogOutput, Builder> {
        Builder(String name) {
            super(TEMPLATE);
            this.set("name", name);
        }

        public Builder stream(PrintStream stream) {
            return (Builder)this.set("stream", stream);
        }

        public Builder formatted(boolean b) {
            return (Builder)this.set("formatted", b);
        }
    }
}

