/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.orbyfied.j8.util.StringUtil;
import net.orbyfied.j8.util.logging.LogLevel;
import net.orbyfied.j8.util.logging.LogPipeline;
import net.orbyfied.j8.util.logging.LogRecord;
import net.orbyfied.j8.util.logging.LogText;
import net.orbyfied.j8.util.logging.LoggerGroup;
import net.orbyfied.j8.util.logging.io.LogOutput;

public class Logger {
    protected final String name;
    protected final LoggerGroup group;
    protected String tag;
    protected ThreadLocal<String> stage;
    @Deprecated
    public final PrintStream out = Logger.createOutStream(this, LogLevel.INFO);
    @Deprecated
    public final PrintStream err = Logger.createOutStream(this, LogLevel.ERROR);
    protected LogPipeline prePipeline = new LogPipeline();
    protected LogPipeline pipeline = new LogPipeline();
    protected List<LogOutput> outputs = new ArrayList<LogOutput>();

    private static PrintStream createOutStream(final Logger logger, final LogLevel level) {
        return new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                for (LogOutput output : logger.outputs) {
                    output.getStream().write(b);
                }
            }
        }, true){

            @Override
            public void write(byte[] buf, int off, int len) {
                logger.log(level, record -> record.getText().newLine(false), new String(buf));
            }
        };
    }

    Logger(LoggerGroup group, String name) {
        LoggerGroup group1 = group;
        if (group == null) {
            group1 = LoggerGroup.GLOBAL;
        }
        this.group = group1;
        this.name = name;
        this.tag = name;
        this.group.applyConfig(this);
    }

    public String getName() {
        return this.name;
    }

    public String getStage() {
        return this.stage.get();
    }

    public String getTag() {
        return this.tag;
    }

    public Logger setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public Logger stage(String stage) {
        this.stage.set(stage);
        return this;
    }

    public LogPipeline pipeline() {
        return this.pipeline;
    }

    public LogPipeline prePipeline() {
        return this.prePipeline;
    }

    public Logger logf(LogLevel level, String format, Object ... values) {
        return this.log(level, StringUtil.pattern(format).format(values));
    }

    public Logger log(LogLevel level, Object ... message) {
        return this.log(level, null, message);
    }

    public Logger log(LogLevel level, Consumer<LogRecord> consumer, Object ... message) {
        LogRecord record = new LogRecord(this, level, this.stage.get(), new LogText(), message);
        record.getText().newLine(true);
        if (consumer != null) {
            consumer.accept(record);
        }
        record.setCancelled(false);
        this.prePipeline.push(record);
        if (record.isCancelled()) {
            return this;
        }
        this.group.queue(record);
        return this;
    }

    public Logger info(String format, Object ... values) {
        return this.logf(LogLevel.INFO, format, values);
    }

    public Logger info(Object ... values) {
        return this.log(LogLevel.INFO, values);
    }

    public Logger ok(String format, Object ... values) {
        return this.logf(LogLevel.OK, format, values);
    }

    public Logger ok(Object ... values) {
        return this.log(LogLevel.OK, values);
    }

    public Logger warn(String format, Object ... values) {
        return this.logf(LogLevel.WARN, format, values);
    }

    public Logger warn(Object ... values) {
        return this.log(LogLevel.WARN, values);
    }

    public Logger err(String format, Object ... values) {
        return this.logf(LogLevel.ERROR, format, values);
    }

    public Logger err(Object ... values) {
        return this.log(LogLevel.ERROR, values);
    }

    public Logger errt(String format, Throwable t, Object ... values) {
        return this.log(LogLevel.ERROR, (LogRecord record) -> record.withMisc(t), StringUtil.format(format, values));
    }
}

