/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr.node;

import java.util.List;
import net.orbyfied.j8.util.math.expr.Context;
import net.orbyfied.j8.util.math.expr.ExpressionFunction;
import net.orbyfied.j8.util.math.expr.ExpressionNode;
import net.orbyfied.j8.util.math.expr.ExpressionValue;
import net.orbyfied.j8.util.math.expr.error.ExprInterpreterException;

public class CallNode
extends ExpressionNode {
    ExpressionNode func;
    List<ExpressionNode> params;

    public CallNode(ExpressionNode func, List<ExpressionNode> params) {
        super(ExpressionNode.Type.CALL);
        this.func = func;
        this.params = params;
    }

    @Override
    public ExpressionValue<?> evaluate(Context context) {
        ExpressionValue<?> fn = this.func.evaluate(context);
        if (fn.getType() != ExpressionValue.Type.FUNCTION) {
            throw new ExprInterpreterException("attempt to call a " + fn.getType().getName() + " value").located(this.getLocation());
        }
        try {
            return ((ExpressionFunction)this.func.evaluate(context).getValueAs()).call(context, this.params.toArray(new ExpressionNode[0]));
        }
        catch (ExprInterpreterException e) {
            if (e.getLocation() == null) {
                e.located(this.getLocation());
            }
            throw e;
        }
    }

    @Override
    protected String getDataAsString() {
        StringBuilder b = new StringBuilder();
        for (ExpressionNode p : this.params) {
            if (!b.isEmpty()) {
                b.append(", ");
            }
            b.append(p);
        }
        return "(" + this.func + ")(" + b + ")";
    }
}

