/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr.node;

import net.orbyfied.j8.util.math.expr.Context;
import net.orbyfied.j8.util.math.expr.ExpressionNode;
import net.orbyfied.j8.util.math.expr.ExpressionValue;
import net.orbyfied.j8.util.math.expr.error.ExprInterpreterException;

public class AssignNode
extends ExpressionNode {
    ExpressionNode source;
    ExpressionNode index;
    ExpressionNode value;

    public AssignNode(ExpressionNode src, ExpressionNode index, ExpressionNode value) {
        super(ExpressionNode.Type.ASSIGN);
        this.source = src;
        this.index = index;
        this.value = value;
    }

    @Override
    public ExpressionValue<?> evaluate(Context context) {
        ExpressionValue<?> val = this.value.evaluate(context);
        ExpressionNode index = this.index;
        ExpressionValue idx = index == null ? context : index.evaluate(context);
        if (this.source == null) {
            throw new ExprInterpreterException("attempt to index a nil value").located(this.getLocation());
        }
        ExpressionValue<?> src = this.source.evaluate(context);
        if (src.isNil()) {
            throw new ExprInterpreterException("attempt to index a nil value").located(this.getLocation());
        }
        try {
            src.structAssign(idx, val);
        }
        catch (ExprInterpreterException e) {
            throw e.located(this.getLocation());
        }
        return val;
    }

    @Override
    protected String getDataAsString() {
        return "(" + this.source + ")[" + this.index + "] = (" + this.value + ")";
    }
}

