/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr;

import net.orbyfied.j8.util.StringReader;
import net.orbyfied.j8.util.math.expr.Operator;
import net.orbyfied.j8.util.math.expr.StringLocation;

public class Token<T> {
    final Type type;
    T value;
    StringLocation loc = StringLocation.EMPTY;
    boolean hasVal = false;

    public Token(Type type, T value) {
        this(type);
        this.setValue(value);
    }

    public Token(Type type) {
        this.type = type;
    }

    public Token<T> located(StringLocation loc) {
        this.loc = loc;
        return this;
    }

    public Token<?> located(String fn, StringReader strReader, int si, int index) {
        return this.located(new StringLocation(fn, strReader, si, index));
    }

    public StringLocation getLocation() {
        return this.loc;
    }

    public Type getType() {
        return this.type;
    }

    public T getValueUnchecked() {
        return this.value;
    }

    public boolean hasValue() {
        return this.hasVal;
    }

    public Token<T> setValue(T val) {
        this.hasVal = true;
        this.value = val;
        return this;
    }

    public Token<T> unsetValue() {
        this.hasVal = false;
        this.value = null;
        return this;
    }

    public T getValue() {
        if (this.type.requiresValue() && this.type.getValueType() != null && !this.hasVal) {
            throw new IllegalStateException("expected value from token of type '" + this.type.getName() + "' , got nil");
        }
        return this.value;
    }

    public <V> V getValueAs() {
        return (V)this.getValue();
    }

    public <V> V getValueAs(Class<V> vClass) {
        return (V)this.getValue();
    }

    public String toString() {
        return "tk" + this.type.name().toUpperCase() + (String)(this.hasVal ? ": " + this.value : "");
    }

    public static enum Type {
        NUMBER_LITERAL("number_literal", Double.TYPE, true),
        OPERATOR("operator", Operator.class, true),
        LEFT_PARENTHESIS("left_paren", null, false),
        RIGHT_PARENTHESIS("right_paren", null, false),
        COMMA("comma", null, false),
        DOT("dot", null, false),
        ASSIGN("assign", null, false),
        ARROW("arrow", null, false),
        COLON("colon", null, false),
        IDENTIFIER("identifier", String.class, true),
        KW_FUNC("keyword_func", null, false);

        final String name;
        final Class<?> valType;
        boolean reqVal;

        private Type(String name, Class<?> valType, boolean reqVal) {
            this.name = name;
            this.valType = valType;
            this.reqVal = reqVal;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getValueType() {
            return this.valType;
        }

        public boolean requiresValue() {
            return this.reqVal;
        }
    }
}

