/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr;

import java.util.Arrays;
import java.util.List;
import net.orbyfied.j8.util.math.expr.Context;
import net.orbyfied.j8.util.math.expr.ExpressionNode;
import net.orbyfied.j8.util.math.expr.ExpressionValue;

public interface ExpressionFunction<T> {
    public static ExpressionFunction<ExpressionNode> wrap(ExpressionFunction<ExpressionValue<?>> func, List<String> types) {
        return new TypedWrappedFunction(func, types);
    }

    public static ExpressionValue<?> make(ExpressionFunction<ExpressionValue<?>> func) {
        return new ExpressionValue<ExpressionFunction<ExpressionNode>>(ExpressionValue.Type.FUNCTION, ExpressionFunction.wrap(func, null));
    }

    public static ExpressionValue<?> make(ExpressionFunction<ExpressionValue<?>> func, List<String> types) {
        return new ExpressionValue<ExpressionFunction<ExpressionNode>>(ExpressionValue.Type.FUNCTION, ExpressionFunction.wrap(func, types));
    }

    public static ExpressionValue<?> make(ExpressionFunction<ExpressionValue<?>> func, String ... types) {
        return new ExpressionValue<ExpressionFunction<ExpressionNode>>(ExpressionValue.Type.FUNCTION, ExpressionFunction.wrap(func, Arrays.asList(types)));
    }

    public ExpressionValue<?> call(Context var1, T[] var2);

    public static class TypedWrappedFunction
    implements ExpressionFunction<ExpressionNode> {
        ExpressionFunction<ExpressionValue<?>> func;
        List<String> types;

        public TypedWrappedFunction(ExpressionFunction<ExpressionValue<?>> func, List<String> types) {
            this.func = func;
            this.types = types;
        }

        public ExpressionValue<?> call(Context ctx, ExpressionNode[] values) {
            if (this.types == null || this.types.isEmpty()) {
                ExpressionValue[] args = new ExpressionValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    args[i] = values[i].evaluate(ctx);
                }
                return this.func.call(ctx.child(true), args);
            }
            ExpressionValue[] args = new ExpressionValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                String type = this.types.get(i);
                ExpressionNode node = values[i];
                ExpressionValue<Object> val = null;
                if (type != null) {
                    switch (type) {
                        case "expression": {
                            val = new ExpressionValue<ExpressionNode>(ExpressionValue.Type.USER, node);
                            break;
                        }
                        default: {
                            val = node.evaluate(ctx);
                            break;
                        }
                    }
                } else {
                    val = node.evaluate(ctx);
                }
                args[i] = val;
            }
            return this.func.call(ctx.child(true), args);
        }
    }
}

