/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import net.orbyfied.j8.util.math.expr.ExpressionFunction;
import net.orbyfied.j8.util.math.expr.ExpressionNode;
import net.orbyfied.j8.util.math.expr.ExpressionValue;
import net.orbyfied.j8.util.math.expr.error.ExprInterpreterException;

public class Context
extends ExpressionValue<HashMap<?, ?>> {
    boolean isLocal;
    Context parent;
    Context global;
    Map<ExpressionValue<?>, ExpressionValue<?>> values;
    public Stack<ExpressionNode> callStack = new Stack();

    public static Context newGlobal() {
        Context ctx;
        ctx.global = ctx = new Context(null, null);
        return ctx;
    }

    public static Context newDefaultGlobal() {
        Context ctx;
        ctx.global = ctx = new Context(null, null);
        Context.openLibs(ctx);
        return ctx;
    }

    @Override
    public ExpressionValue<HashMap<?, ?>> structIndex(ExpressionValue<?> key) {
        return this.getValueStrict(key);
    }

    @Override
    public void structAssign(ExpressionValue<?> key, ExpressionValue<?> value) {
        this.setValueStrict(key, value);
    }

    protected Context(Context parent, Context global) {
        super(ExpressionValue.Type.TABLE, new HashMap());
        this.parent = parent;
        this.global = global;
        this.values = (Map)this.getValueAs();
    }

    public Context getGlobal() {
        return this.global;
    }

    public Context getParent() {
        return this.parent;
    }

    public Context child() {
        return new Context(this, this.global);
    }

    public Context child(boolean isLocal) {
        Context ctx = new Context(this, this.global);
        ctx.isLocal = isLocal;
        return ctx;
    }

    public Map<ExpressionValue<?>, ExpressionValue<?>> getValues() {
        return this.values;
    }

    public <V> ExpressionValue<V> getValue(Object obj) {
        return this.getValueStrict(ExpressionValue.of(obj));
    }

    public <V> ExpressionValue<V> getValueStrict(ExpressionValue<?> key) {
        ExpressionValue<V> val;
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        if (this.parent != null && !this.parent.isLocal && !(val = this.parent.getValueStrict(key)).isNil()) {
            return val;
        }
        if (this.global != null && this.global != this && !(val = this.global.getValueStrict(key)).isNil()) {
            return val;
        }
        return ExpressionValue.NIL;
    }

    public Context setValue(Object key, Object val) {
        return this.setValueStrict(ExpressionValue.of(key), ExpressionValue.of(val));
    }

    public Context setValueStrict(ExpressionValue<?> key, ExpressionValue<?> value) {
        this.values.put(key, value);
        return this;
    }

    private static ExpressionValue<?> makeDD(Function<Double, Double> func) {
        return ExpressionFunction.make((ctx, args) -> {
            if (args.length < 1) {
                throw new ExprInterpreterException("expected double argument");
            }
            return ExpressionValue.ofDouble((Double)func.apply((Double)args[0].checkType(ExpressionValue.Type.NUMBER).getValueAs()));
        });
    }

    public static Context openLibs(Context context) {
        context.tableSet("eval", ExpressionFunction.make((ctx, values) -> values[0].getValueAs(ExpressionNode.class).evaluate(ctx), "expression"));
        context.tableSet("expr", ExpressionFunction.make((ctx, values) -> values[0], "expression"));
        context.tableSet("to_string", ExpressionFunction.make((ctx, values) -> new ExpressionValue<String>(ExpressionValue.Type.STRING, values[0].toString())));
        ExpressionValue<?> tMath = ExpressionValue.newTable();
        context.tableSet("avg", ExpressionFunction.make((ctx, args) -> {
            double n = 0.0;
            int l = args.length;
            for (int i = 0; i < l; ++i) {
                n += args[i].checkType(ExpressionValue.Type.NUMBER).getValueAs(Double.class).doubleValue();
            }
            return ExpressionValue.ofDouble(n / (double)l);
        }));
        context.tableSet("sqrt", Context.makeDD(Math::sqrt));
        context.tableSet("sin", Context.makeDD(Math::sin));
        context.tableSet("cos", Context.makeDD(Math::cos));
        context.tableSet("tan", Context.makeDD(Math::tan));
        context.setValue("math", tMath);
        return context;
    }

    @Override
    public String toString() {
        return "(" + (this.parent != null ? "->" : "") + "Context)";
    }
}

