/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math;

import java.text.DecimalFormat;
import net.orbyfied.j8.util.StringUtil;
import net.orbyfied.j8.util.math.Vector;

public class Matrix {
    int w;
    int h;
    double[][] data;
    private static final DecimalFormat format = new DecimalFormat();

    public Matrix(int w, int h) {
        this.w = w;
        this.h = h;
        this.data = new double[w][h];
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public double[][] getData() {
        return this.data;
    }

    public Matrix set(int x, int y, double d) {
        this.data[x][y] = d;
        return this;
    }

    public Matrix setColumn(int x, double[] d) {
        this.data[x] = d;
        return this;
    }

    public Matrix setRow(int y, double[] d) {
        for (int x = 0; x < this.w; ++x) {
            this.data[x][y] = d[x];
        }
        return this;
    }

    public Matrix copyFrom(Matrix a) {
        if (a.w != this.w || a.h != this.h) {
            return this;
        }
        for (int x = 0; x < this.w; ++x) {
            for (int y = 0; y < this.h; ++y) {
                this.data[x][y] = a.data[x][y];
            }
        }
        return this;
    }

    public double get(int x, int y) {
        return this.data[x][y];
    }

    public Vector product(Vector vec) {
        return vec;
    }

    public String toString() {
        int x;
        int y;
        StringBuilder b = new StringBuilder();
        int[] ml = new int[this.w];
        String[][] s = new String[this.w][this.h];
        for (y = this.h - 1; y >= 0; --y) {
            for (x = 0; x < this.w; ++x) {
                double d = this.data[x][y];
                String ds = format.format(d);
                if (ds.length() > ml[x]) {
                    ml[x] = ds.length();
                }
                s[x][y] = ds;
            }
        }
        for (y = this.h - 1; y >= 0; --y) {
            b.append("| ");
            for (x = 0; x < this.w; ++x) {
                if (x != 0) {
                    b.append(", ");
                }
                b.append(StringUtil.extendTail(s[x][y], ml[x], ' '));
            }
            b.append(" |").append('\n');
        }
        return b.toString();
    }

    static {
        format.setMaximumFractionDigits(4);
    }
}

