/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

public class LogText {
    final HashMap<String, Object> mapped = new LinkedHashMap<String, Object>();
    final ArrayList<Object> linear = new ArrayList();
    Boolean newLine = false;

    public static Stringable formatted(String unformatted, String formatted) {
        return format -> format ? formatted : unformatted;
    }

    public HashMap<String, Object> getMapped() {
        return this.mapped;
    }

    public ArrayList<Object> getLinear() {
        return this.linear;
    }

    public LogText lockNewline() {
        this.newLine = null;
        return this;
    }

    public LogText newLine(boolean b) {
        if (this.newLine == null) {
            return this;
        }
        this.newLine = b;
        return this;
    }

    public boolean newLine() {
        return this.newLine;
    }

    public LogText put(Object val) {
        this.mapped.put(Integer.toHexString(System.identityHashCode(val)), val);
        this.linear.add(val);
        return this;
    }

    public LogText put(String key, Object val) {
        this.mapped.put(key, val);
        this.linear.add(val);
        return this;
    }

    public LogText put(String key, int idx, Object val) {
        this.mapped.put(key, val);
        this.linear.add(idx, val);
        return this;
    }

    public LogText sub(String key) {
        LogText n = new LogText();
        this.put(key, n);
        return n;
    }

    public LogText sub(String key, int idx) {
        LogText n = new LogText();
        this.put(key, idx, n);
        return n;
    }

    public <T> T get(String key) {
        return (T)this.mapped.get(key);
    }

    public <T> LogText use(String key, Consumer<T> consumer) {
        T t = this.get(key);
        if (consumer != null) {
            consumer.accept(t);
        }
        return this;
    }

    public <T> T getOrCreate(String key, Function<String, T> function) {
        if (!this.mapped.containsKey(key)) {
            T t = function.apply(key);
            this.mapped.put(key, t);
            this.linear.add(t);
        }
        return (T)this.mapped.get(key);
    }

    public <T> LogText useOrCreate(String key, Function<String, T> constructor, Consumer<T> consumer) {
        T t = this.getOrCreate(key, constructor);
        if (consumer != null) {
            consumer.accept(t);
        }
        return this;
    }

    public String toString(boolean format) {
        StringBuilder b = new StringBuilder();
        int l = this.linear.size();
        for (int i = 0; i < l; ++i) {
            Object entry = this.linear.get(i);
            if (entry instanceof LogText) {
                LogText ls = (LogText)entry;
                b.append(ls.toString(format));
                continue;
            }
            if (entry instanceof Stringable) {
                Stringable s = (Stringable)entry;
                b.append(s.toString(format));
                continue;
            }
            b.append(entry);
        }
        if (this.newLine != null && this.newLine.booleanValue()) {
            b.append("\n");
        }
        return b.toString();
    }

    public String toString() {
        return "LogText{" + this.linear.toString() + "}";
    }

    public static interface Stringable {
        public String toString(boolean var1);
    }
}

