/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging;

import java.awt.Color;
import java.util.function.BiConsumer;
import net.orbyfied.j8.util.logging.LogRecord;
import net.orbyfied.j8.util.logging.LogText;
import net.orbyfied.j8.util.logging.formatting.TextFormat;

public class LogLevel {
    String id;
    BiConsumer<LogRecord, LogText> tagger;
    public static final LogLevel INFO = LogLevel.ofString("info", "INFO", new Color(5031139));
    public static final LogLevel OK = LogLevel.ofString("ok", "OK", new Color(8183129));
    public static final LogLevel WARN = LogLevel.ofString("warn", "WARN", new Color(14595924));
    public static final LogLevel ERROR = LogLevel.ofString("error", "ERROR", new Color(15359068));

    public LogLevel(String id, BiConsumer<LogRecord, LogText> tagger) {
        this.id = id;
        this.tagger = tagger;
    }

    public String getIdentifier() {
        return this.id;
    }

    public BiConsumer<LogRecord, LogText> getTagger() {
        return this.tagger;
    }

    public void tag(LogRecord record, LogText string) {
        this.tagger.accept(record, string);
    }

    private static LogLevel ofString(String id, String unformatted, Color color) {
        TextFormat tf = TextFormat.of(color);
        return new LogLevel(id, (record, string) -> string.put("level-" + id, format -> {
            if (format) {
                return tf + unformatted + TextFormat.RESET;
            }
            return unformatted;
        }));
    }
}

