/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging;

import net.orbyfied.j8.util.logging.LogPipeline;
import net.orbyfied.j8.util.logging.LogRecord;

public abstract class LogHandler {
    protected Priority priority = Priority.NONE;
    protected String name;
    protected boolean async = false;

    public static LogHandler of(final Action action) {
        return new LogHandler(){

            @Override
            protected void handle(LogPipeline pipeline, LogRecord record) {
                action.handle(pipeline, record);
            }
        };
    }

    public static LogHandler of(String name, Action action) {
        return LogHandler.of(action).named(name);
    }

    public static LogHandler of(String name, Priority priority, Action action) {
        return LogHandler.of(action).named(name).prioritized(priority);
    }

    public LogHandler() {
    }

    public LogHandler(String name) {
        this.name = name;
    }

    public LogHandler(String name, Priority priority) {
        this.name = name;
        this.priority = priority;
    }

    public LogHandler(Priority priority) {
        this.priority = priority;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String name() {
        return this.name;
    }

    public Priority priority() {
        return this.priority;
    }

    public LogHandler async(boolean b) {
        this.async = b;
        return this;
    }

    public LogHandler named(String name) {
        this.name = name;
        return this;
    }

    public LogHandler prioritized(Priority priority) {
        this.priority = priority;
        return this;
    }

    protected abstract void handle(LogPipeline var1, LogRecord var2);

    public static interface Action {
        public void handle(LogPipeline var1, LogRecord var2);
    }

    public static enum Priority {
        HIGHEST(0.0f),
        HIGH(0.25f),
        MEDIUM(0.4f),
        LOW(0.7f),
        LOWEST(0.9f),
        NONE(-1.0f);

        float posApprox;

        private Priority(float posApprox) {
            this.posApprox = posApprox;
        }

        public float getPositionApproximation() {
            return this.posApprox;
        }
    }
}

