/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.orbyfied.j8.util.builder.Property;
import net.orbyfied.j8.util.builder.Values;

public class Properties {
    final List<Property<?>> properties = new ArrayList();
    final Map<String, Property<?>> propertyMap = new HashMap();
    final String prefix;

    public Properties(String prefix) {
        this.prefix = prefix;
    }

    public String prefix() {
        return this.prefix;
    }

    public List<Property<?>> getAll() {
        return Collections.unmodifiableList(this.properties);
    }

    public <T> Property<T> get(String name) {
        return this.getExact(this.prefix + name);
    }

    public <T> Property<T> getExact(String id) {
        return this.propertyMap.get(id);
    }

    public Properties remove(Property<?> property) {
        this.properties.remove(property);
        this.propertyMap.remove(property.name);
        return this;
    }

    public Properties remove(String name) {
        return this.remove(this.get(name));
    }

    public Properties removeExact(String name) {
        return this.remove(this.getExact(name));
    }

    public Properties addExact(Property<?> property) {
        this.properties.add(property);
        this.propertyMap.put(property.name, property);
        return this;
    }

    public Properties add(String name, Property<?> property) {
        return this.addExact(property.named(this.prefix + name));
    }

    public Values blank() {
        return new Values(this);
    }

    public Values defaults() {
        Values values = this.blank();
        for (Property<?> property : this.properties) {
            if (!property.defaulted()) continue;
            values.set(property, property.defaultValue());
        }
        return values;
    }
}

